/*
 * File   : mm.c
 *
 * Source : Based on mm.c by DJ Delorie.
 */

#define _INCLUDE_POSIX_SOURCE
#define _INCLUDE_XOPEN_SOURCE

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#if defined(__WATCOMC__) || defined(MSC)
#include <direct.h>
#else
#include <dirent.h>
#endif

#ifdef __WATCOMC__
#define   MAKETMPL    "maketmpl.wcc"
#define   MAKEFILE    "makefile.wcc"
#define   DIRSEP      '\\'
#define   LINESEP     '&'
#define   OBJEXT      "obj"
#define   SOURCE      ""
#define   OBJECT      "/fo="
#else
#define   MAKETMPL    "maketmpl"
#define   MAKEFILE    "makefile.n"
#define   DIRSEP      '/'
#define   LINESEP     '\\'
#define   OBJEXT      "o"
#define   SOURCE      "-c "
#define   OBJECT      "-o "
#endif

void fail (char *s1, char *s2)
{
  fprintf (stderr, "ERROR: %s \"%s\"\n", s1, s2);
  exit (EXIT_FAILURE);
}

char *strlwr (char *s)
{
#ifdef MSDOS
  char *p;

  for (p=s; *p; p++) *p = tolower(*p);
#endif
  return s;
}

void handle_wild (FILE *f, char *dir, char *wild)
{
  int m, n;
  DIR *dirp;
  char *cp, fname[256];
  struct dirent *dep;
  struct stat stbuf;

  if ((dirp = opendir (dir)) == NULL) fail ("Illegal directory name", dir);

  while ((dep = readdir (dirp)) != NULL)
  {
    sprintf (fname, "%s%c%s", dir, DIRSEP, dep->d_name);
    stat (fname, &stbuf);
    strlwr (fname);
    if ((stbuf.st_mode & S_IFMT) != S_IFDIR)   /* skip dirs */
    {
      if (((m = strlen(fname)) >= (n = strlen(wild))) &&
             (!strcmp (fname + m - n, wild)))
      {
	fprintf (f, "\t$(ODIR)%c", DIRSEP);
	sprintf (fname, "%s", dep->d_name);
	strlwr (fname);
	sprintf (strrchr(fname,'.'), ".%s %c\n", OBJEXT, LINESEP);
	fputs (fname, f);
      }
    }
  }
  closedir (dirp);
}

void handle_wild2 (FILE *f, char *dir, char *wild)
{
  int m, n;
  DIR *dirp;
  char *cp, fname[256];
  struct dirent *dep;
  struct stat stbuf;

  if ((dirp = opendir (dir)) == NULL) fail ("Illegal directory name", dir);

  while ((dep = readdir (dirp)) != NULL)
  {
    sprintf (fname, "%s%c%s", dir, DIRSEP, dep->d_name);
    stat (fname, &stbuf);
    strlwr (fname);
    if ((stbuf.st_mode & S_IFMT) != S_IFDIR)   /* skip dirs */
    {
      if (((m = strlen(fname)) >= (n = strlen(wild))) &&
             (!strcmp (fname + m - n, wild)))
      {
        strcpy (fname, dep->d_name);
        strlwr (fname);
	cp = strrchr(fname, '.');   /* strip extension */
	*cp = 0;
	fprintf (f, "$(ODIR)%c%s.%s : %s%c%s%s\n", DIRSEP, fname, OBJEXT, 
	                                           dir, DIRSEP, fname, wild);
	fprintf (f, "\t$(CC) $(CFLAGS) %s %s%c%s%s %s$(ODIR)%c%s.%s\n",
           SOURCE, dir, DIRSEP, fname, wild, OBJECT, DIRSEP, fname, OBJEXT);
	fprintf (f, "\n");
      }
    }
  }
  closedir (dirp);
}

void handle_dir(FILE *f, char *line)
{
  char fname[100];

  sscanf (line, "%s", fname);
  handle_wild (f, fname, ".c");
  handle_wild (f, fname, ".cc");
  handle_wild (f, fname, ".S");
}

void handle_dir2(FILE *f, char *line)
{
  char fname[100];

  sscanf (line, "%s", fname);
  handle_wild2 (f, fname, ".c");
  handle_wild2 (f, fname, ".cc");
  handle_wild2 (f, fname, ".S");
}

int main()
{
  FILE *fin, *fout;
  char buf[200];

  if ((fin = fopen(MAKETMPL, "r")) == NULL) fail ("Unable to open", MAKETMPL);
  if ((fout = fopen(MAKEFILE, "w")) == NULL) fail ("Unable to open", MAKEFILE);
  fprintf(fout, "# This file is generated from maketmpl by mm.c\n");
  while (fgets(buf, 200, fin) != NULL)
  {
    if (strncmp(buf, "@dir ", 5) == 0)
      handle_dir(fout, buf+5);
    else if (strncmp(buf, "@dir2 ", 6) == 0)
      handle_dir2(fout, buf+6);
    else
      fputs(buf, fout);
  }
  fclose(fin);
  fclose(fout);
  return 0;
}
