#ifndef _3DTOOLS_H
#define _3DTOOLS_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "mode13h.h"
#include "sin.h"

#define DIST 1024       // distance between the monitor and the eye, in pixels
#define MAX_XYZ 2097151 // max value in any direction (x, y, z)

typedef struct
{
   long localX, localY, localZ;

} pointRec;

class point3d
{

public:

    long x3d, y3d, z3d;
    long localX, localY, localZ, rotoX, rotoY, rotoZ;
    long oX, oY, oZ;
    long x2d, y2d;
    long nX, nY, nZ, nCount;
    void *normal;

    // I never finished implementing spherical coordinates, feel free to 
    // pick up where I left off ;)

    // spherical coordinate implementation -
    // rho   = sqrt(x3d^2 + y3d^2 + z3d^2) = distance
    // phi   = arccos(y3d / rho) = angle of elevation
    // theta = arctan(x3d / z3d) = angle in the XZ plane (yaw)
    // l and g prefixes denote local and global coordinates
    //
    // x = p(sin )(cos )
    // y = p(cos )
    // z = p(sin )(sin )
    //
    // as you can see this is about half the imuls of the conventional method
    // and should also result in SMALLER POINT OBJECTS (just for you, Hurri)

    // long lRho, lPhi, lTheta, gRho, gPhi, gTheta;

    point3d();
	point3d(long x, long y, long z);

    void save(FILE *fp);
    void load(FILE *fp);

    void setTo(long x, long y, long z);

    void xform2d();
    void display(int color);
    void setNewOrigin(point3d *p);
    void globalXform2origin(point3d *p);
    void copyOrigin(point3d *p);

    void localRotate(int dTheta, int dPhi);
    void localRotate(int tX, int tY, int tZ);
	void localRotate(int *trig);
	void globalRotate(int *trig);

	void translate(long dX, long dY, long dZ);
    void globalXform();

    void zeroNormal();
    void addNormal(int dX, int dY, int dZ);
    void avgNormal();

    void matRotate();

	~point3d();

private:

    long i, j, k;
	int xDeg, yDeg, zDeg;


};

int dotProduct(point3d *p1, point3d *p2);


class line3d
{

public:

    line3d(point3d *p1, point3d *p2, int c);

	line3d(long x1, long y1, long z1, long x2, long y2, long z2, int c);

    void draw();

    void calcVectors();

    long xOfT(double t);

    long yOfT(double t);

    long zOfT(double t);

    double tOfX(long x);

    double tOfY(long y);

    double tOfZ(long z);

    void localRotate(double tX, double tY, double tZ);

    ~line3d();

private:

    point3d *point1, *point2;
    int color, flag;
    long i, j, k;

};

typedef struct
{

    int p1, p2, p3, normal, color;

} polyRec;

#define sNone       0
#define sFlat       1
#define sGouraud    2

#define fBoth       0
#define fInside     1
#define fOutside    2

class polygon
{

public:
    point3d *p1, *p2, *p3, *normal;
    int color;
    int facing, shading;

    polygon();

    polygon(point3d *v1, point3d *v2, point3d *v3, int c);
    polygon(point3d *v1, point3d *v2, point3d *v3, point3d *norm, int c);

    void setTo(point3d *v1, point3d *v2, point3d *v3);

    long avgZ();

    void setColor(int c);

    void wireFrame();
    void paintSolid();
    void gShade();

    void setNewOrigin(point3d *p);

    void localRotate(int *trig);
    void globalRotate(int *trig);

    void setGNormals();

    void setShading(int shade);
    void setFacing(int face);
    void display();
    void zbFlat();

    ~polygon();

private:
    line3d **line;
    int count, dot, dot1, dot2, dot3;

};

typedef struct
{
    char OTMtag[18];
    char newline[1];
    int numPoints, numPolys;

} objFileHeader;


class obj3d
{

public:

    obj3d(long x, long y, long z);

    void save(FILE *fp);
    void load(FILE *fp);

	void addLocalPoint(long x, long y, long z);
    void addLocalPoint(point3d *p);

	void addGlobalPoint(long x, long y, long z);
    void addGlobalPoint(point3d *p);

    void addLocalPoly(polygon *pg);
    void addLocalPoly(int p1, int p2, int p3, int c);

    void addGlobalPoly(polygon *pg);

    int getPointNum(long x, long y, long z);
    int getPointNum(point3d *p);

    void localRotate(int dTheta, int dPhi);
    void localRotate(int tX, int tY, int tZ);
	void globalRotate(int *trig);

	void translate(int dX, int dY, int dZ);

	void sortPlanes();

	void paintDots();
    void wireFrame();
    void paintSolid();
    void gShade();

	void setLocation(long x, long y, long z);

    void setGNormals();
    void display();
    void zbFlat();
    void addNormal(long x, long y, long z);
    void addNormal(point3d *p);

    void matRotate(int tX, int tY, int tZ);

    ~obj3d();

    point3d  **point;
    point3d  **normal;
    polygon  **poly;
    int numPoints, numNormals, numPolys, count, xDeg, yDeg, zDeg;

private:

    point3d *origin;
    line3d *xAxis, *yAxis, *zAxis;
	int *trig;

};

#define MAX_OBJS 128

class world3d
{

public:

	world3d();

	void rotate(int tX, int tY, int tZ);

	~world3d();

private:

    obj3d **object;
	int numObjs;

};

extern world3d world;

class viewPoint
{

public:

    point3d *location, *light, *view;

	viewPoint();

	void rotate(int tX, int tY, int tZ);
	void translate(int dX, int dY, int dZ);

	~viewPoint();

private:


};

extern viewPoint camera;

#endif
