/*
	MT.H
	----
	(c) PLOTSO 1997

*/
#ifndef __MTROUT_BC_12_
#define __MTROUT_BC_12_

enum errors { Ok, File, Mem, Size };
extern errors MTerror;
class bitmap;
class mtfont;

class rgb {
public:
	char r,g,b;
};
typedef rgb palette [256];
typedef long fixed;

extern char key[0x80];
extern bitmap *screen;

extern int tx,ty;
extern short sintbl[256],costbl[256];
errors err();

void createbitmap(bitmap *pic,int lev,int kor);
char initmath();

inline short fix2int(fixed num)
{
	return (num>>16);
}
inline fixed int2fix(long num)
{
	return (fixed)(num<<16);
}

char *load_pcx(char *file,rgb *pal=0,int *lev=0,int *kor=0);

void fadein(palette pal,int luku);
void fadeout(palette pal,int luku);
void setpal(palette pal);
void setpalblack();
void setcol(char col,char r,char g,char b);
void getcol(char col,char *r,char *g,char *b);
void fadepartin(unsigned int eka,unsigned int monta,palette pal,unsigned int luku);
void fadepartout(unsigned int eka,unsigned int monta,palette pal,unsigned int luku);
void palleft(unsigned int eka,unsigned int monta,palette pal);
void palright(unsigned int eka,unsigned int monta,palette pal);
rgb *loadpalette(char *file,long offs=-1);
void loadpalette(palette pal,char *file,long offs=-1);

char ismouse();
void showmouse();
void hidemouse();
char mousepos(int *x,int *y,int *but);
void setmousepos(int x,int y);
void setmousearea(int xm,int ym,int xa,int ya);
void getmousespd(int *hor,int *ver);
void setmousespd(int hor,int ver);

void installkeyb();
void removekeyb();
char keypressed();
void waitifprs(char but);

void freefont(mtfont *fnt);
mtfont *loadfont(char *fntfile);
void mtwrite(int x,int y,char *str,mtfont *fnt,int minus=0,bitmap *dest=screen);
void mtputchar(int x,int y,char ch,mtfont *fnt,int minus=0,bitmap *dest=screen);
void mtwritecol(int x,int y,char *str,mtfont *fnt,char col, int minus=0,bitmap *dest=screen);
void mtputcharcol(int x,int y,char ch,mtfont *fnt,char col,int minus=0,bitmap *dest=screen);

void setmode(int mode);
void vretrace();
void put_image(int x,int y,int lev,int kor,char *pic,bitmap *dest);
void put_sprite(int x,int y,int lev,int kor,char *pic,bitmap *dest);
void scale_pic(int x,int y,int lev,int kor,int uuslev,int uuskor,char *pic,bitmap *dest);
void scale_spr(int x,int y,int lev,int kor,int uuslev,int uuskor,char *pic,bitmap *dest);
void put_spritecol(int x,int y,int lev,int kor,char col,char *pic,bitmap *dest);

void clear(bitmap *dest=screen);
void clear(char col,bitmap *dest=screen);
void putpixel(int x,int y,char col,bitmap *dest=screen);
char getpixel(int x,int y,bitmap *sour=screen);
void line(int x1,int y1,int x2,int y2,char c,bitmap *dest=screen);
void vline(int x,int y,int kor,char c,bitmap *dest=screen);
void hline(int x,int y,int lev,char c,bitmap *dest=screen);
void hline2(int x,int x2,int y,char c,bitmap *dest=screen);
void vline2(int x,int y,int y2,char c,bitmap *dest=screen);
void circle(int x,int y,int r,char c,bitmap *dest=screen);
void fcircle(int x,int y,int r,char c,bitmap *dest=screen);
void copy(bitmap *sour,bitmap *dest, int sx,int sy,int dx,int dy,int lev,int kor);
void mirrorv(bitmap *dest,bitmap *sour);
inline void setcut(int x,int y,int ex,int ey,bitmap *pic);

class bitmap {
public:
	bitmap() { data=0;lev=kor=up=down=left=right=0; }
	bitmap(int flev,int fkor) { createbitmap(this,flev,fkor); }
	bitmap(char *file,rgb *pal=0) { loadpcx(file,pal); }
	~bitmap() { free(); }

	void loadpcx(char *file,rgb *pal=0) { data=load_pcx(file,pal,&lev,&kor); }
	void free() { if(data) delete [] data;data=0;lev=kor=up=down=left=right=0; }

	void putimage(int x,int y,bitmap *dest=screen) { put_image(x,y,lev,kor,data,dest); }
	void putsprite(int x,int y,bitmap *dest=screen) { put_sprite(x,y,lev,kor,data,dest); }
	void scale(int x,int y,int uuslev,int uuskor,bitmap *dest=screen) { scale_pic(x,y,lev,kor,uuslev,uuskor,data,dest); }
	void scalespr(int x,int y,int uuslev,int uuskor,bitmap *dest=screen) { scale_spr(x,y,lev,kor,uuslev,uuskor,data,dest); }
	void putspritecol(int x,int y,char col,bitmap *dest=screen) { put_spritecol(x,y,lev,kor,col,data,dest); }
	void hide(int x,int y,bitmap *sour,bitmap *dest) { copy(sour,dest,x,y,x,y,lev,kor); }
	void createmirrorv(bitmap *sour) { mirrorv(this,sour); }
	void cut(int x,int y,int x2,int y2) { setcut(x,y,x2,y2,this); }

//private:
	int lev,kor;
	char *data;
	int up,down,left,right;
};
class mtfont {
public:
       char sign[7];
       int monta;
       char *jono;
       int space,enter;
       bitmap datat[256];
};
inline void setcut(int x,int y,int ex,int ey,bitmap *pic)
{
	if(x>0) pic->left=x; else pic->left=0;
	if(y>0) pic->up=y; else pic->up=0;
	if(ex<pic->lev) pic->right=ex; else pic->right=pic->lev;
	if(ey<pic->kor) pic->down=ey; else pic->down=pic->kor;
}
inline void toscreen(bitmap *pic) { put_image(0,0,pic->lev,pic->kor,pic->data,screen); }
inline void putpixel2(int x,int y,char col,bitmap *dest=screen)
{
	dest->data[y*dest->lev+x]=col;
}
inline char getpixel2(int x,int y,bitmap *sour=screen)
{
	return sour->data[y*sour->lev+x];
}
inline void mtwrite(char *str,mtfont *fnt,int minus=0,bitmap *dest=screen) { mtwrite(tx,ty,str,fnt,minus,dest); }
inline void mtputchar(char ch,mtfont *fnt,int minus=0,bitmap *dest=screen) { mtputchar(tx,ty,ch,fnt,minus,dest); }
inline void mtwritecol(char *str,mtfont *fnt,char col, int minus=0,bitmap *dest=screen) { mtwritecol(tx,ty,str,fnt,col,minus,dest); }
inline void mtputcharcol(char ch,mtfont *fnt,char col,int minus=0,bitmap *dest=screen) { mtputcharcol(tx,ty,ch,fnt,col,minus,dest); }
inline void mtgoto(int x,int y) { tx=x; ty=y; }

#define KEY_ESC               1
#define KEY_1                 2
#define KEY_2                 3
#define KEY_3                 4
#define KEY_4                 5
#define KEY_5                 6
#define KEY_6                 7
#define KEY_7                 8
#define KEY_8                 9
#define KEY_9                 10
#define KEY_0                 11
#define KEY_MINUS             12
#define KEY_EQUALS            13
#define KEY_BACKSPACE         14
#define KEY_TAB               15
#define KEY_Q                 16
#define KEY_W                 17
#define KEY_E                 18
#define KEY_R                 19
#define KEY_T                 20
#define KEY_Y                 21
#define KEY_U                 22
#define KEY_I                 23
#define KEY_O                 24
#define KEY_P                 25
#define KEY_OPENBRACE         26
#define KEY_CLOSEBRACE        27
#define KEY_ENTER             28
#define KEY_CTRL              29
#define KEY_A                 30
#define KEY_S                 31
#define KEY_D                 32
#define KEY_F                 33
#define KEY_G                 34
#define KEY_H                 35
#define KEY_J                 36
#define KEY_K                 37
#define KEY_L                 38
#define KEY_COLON             39
#define KEY_QUOTE             40
#define KEY_TILDE             41
#define KEY_LSHIFT            42
#define KEY_BACKSLASH         43
#define KEY_Z                 44
#define KEY_X                 45
#define KEY_C                 46
#define KEY_V                 47
#define KEY_B                 48
#define KEY_N                 49
#define KEY_M                 50
#define KEY_COMMA             51
#define KEY_STOP              52
#define KEY_SLASH             53
#define KEY_RSHIFT            54
#define KEY_ASTERISK          55
#define KEY_ALT               56
#define KEY_SPACE             57
#define KEY_CAPSLOCK          58
#define KEY_F1                59
#define KEY_F2                60
#define KEY_F3                61
#define KEY_F4                62
#define KEY_F5                63
#define KEY_F6                64
#define KEY_F7                65
#define KEY_F8                66
#define KEY_F9                67
#define KEY_F10               68
#define KEY_NUMLOCK           69
#define KEY_SCRLOCK           70
#define KEY_HOME              71
#define KEY_UP                72
#define KEY_PGUP              73
#define KEY_MINUS_PAD         74
#define KEY_LEFT              75
#define KEY_5_PAD             76
#define KEY_RIGHT             77
#define KEY_PLUS_PAD          78
#define KEY_END               79
#define KEY_DOWN              80
#define KEY_PGDN              81
#define KEY_INSERT            82
#define KEY_DEL               83
#define KEY_F11               87
#define KEY_F12               88
#define KEY_PAD               100


#endif
