/*****************************************************
; Filename 	: image.h
;
; Date 		: 29-6-94
; Mod. Date	:  4-7-94
;
; Others	: Obtained from Ferraro
;****************************************************/
#ifndef IMAGE_H
#define IMAGE_H

#ifdef __cplusplus
extern "C" {
#endif
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <alloc.h>

#include <string.h>
#include "video.h"
#include "palette.h"
#include "std_defs.h"

typedef struct wgtsprite
{
	int	slot;
	int	width;
	int	height;
	byte	*data;

} WGTSPRITE;

typedef struct wgtspritefile
{
	int	version;
	byte	id[13];
	byte	palette[768];
	int	total;
	
} WGTSPRITEHDR;

typedef struct sprite
{
	int	index;
	int	width;
	int	height;
	byte	*data;

} SPRITETYPE;

typedef struct spriteheader
{
	int		flag;
	byte		type[8];
	byte		palette[768];
	int		total;
	SPRITETYPE 	**sprite;
} SPRITE;

typedef struct CELHeader {
	int	magic_number;
	int	width;
	int 	height;
	int	x_coord;
	int	y_coord;
	int	compress_type;
	long	image_size;
	int	reserved[8];
	byte	palette[768];
	byte	*image;
} CELHDR;


int  		mtLoadPCX(char *filename);

WGTSPRITE  	**mtLoadWGT(char *filename,byte palette[]);
int 		mtSaveWGT(char *fontname,WGTSPRITE **sprite);

SPRITE 		*mtLoadBM(char *filename, byte palette[]); 
int 		mtSaveBM(char *filename,SPRITE *sprite);

#ifdef __cplusplus
}
#endif

#endif IMAGE_H
