/* lzo1x_cc.h -- definitions for the the LZO1X compression driver

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the LZO library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */


/* WARNING: this file should *not* be used by applications. It is
   part of the implementation of the library and is subject
   to change.
 */


#ifndef __LZO1X_CC_H
#define __LZO1X_CC_H


/***********************************************************************
//
************************************************************************/

extern const lzo_compress_t _lzo1x_1_compress_func;
extern const lzo_compress_t _lzo1x_2_compress_func;
extern const lzo_compress_t _lzo1x_3_compress_func;
extern const lzo_compress_t _lzo1x_4_compress_func;
extern const lzo_compress_t _lzo1x_5_compress_func;
extern const lzo_compress_t _lzo1x_6_compress_func;
extern const lzo_compress_t _lzo1x_7_compress_func;
extern const lzo_compress_t _lzo1x_8_compress_func;
extern const lzo_compress_t _lzo1x_9_compress_func;

extern const lzo_compress_t _lzo1x_99_compress_func;


/***********************************************************************
//
************************************************************************/

lzo_compress_t _lzo1x_get_compress_func(int clevel);

int _lzo1x_do_compress   ( const lzo_byte *in,  lzo_uint  in_len,
								 lzo_byte *out, lzo_uint *out_len,
								 lzo_voidp wrkmem,
								 lzo_compress_t func );


#endif /* already included */

/*
vi:ts=4
*/


