/* lzo1c_d.sh -- assembler implementation of the LZO1C decompression algorithm

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the LZO library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */


/*
 * This file has been adapted from code generously contributed by
 * Laszlo Molnar aka ML1050 <molnarl@postabank.hu>
 *
 * Many thanks, Laszlo !
 */


/***********************************************************************
//
************************************************************************/

        ALIGN3
L1:             
        xorl    %eax,%eax
        movb    (%esi),%al
        incl    %esi
        cmpb    $32,%al
        jnb     MATCH

        orb     %al,%al
        jz      L12
        movl    %eax,%ecx
LIT:            
        rep     
        movsb   
M1:             
        movb    (%esi),%al
        incl    %esi

        cmpb    $32,%al
        jb      M2
MATCH:          
        cmpb    $64,%al
        jb      N3

        movl    %eax,%ecx
        andb    $31,%al
        leal    -1(%edi),%edx
        shrl    $5,%ecx
        subl    %eax,%edx
        movb    (%esi),%al
        incl    %esi

        shll    $5,%eax
        subl    %eax,%edx
        incl    %ecx
        xchgl   %esi,%edx
        rep     
        movsb   
        movl    %edx,%esi
N2:             
        jmp     L1

        ALIGN3
L12:
        LODSB
        leal    32(%eax),%ecx
        cmpb    $248,%al
        jb      LIT

        movl    $280,%ecx
        subb    $248,%al
        jz      L11
        xchgl   %eax,%ecx
        xorb    %al,%al
        shll    %cl,%eax
        xchgl   %eax,%ecx     
L11:            
        rep     
        movsb   
        jmp     L1

        ALIGN3
M2:             
        leal    -1(%edi),%edx
        subl    %eax,%edx
        LODSB
        shll    $5,%eax
        subl    %eax,%edx
        xchgl   %esi,%edx
        movsb   
        movsb   
        movsb   
        movl    %edx,%esi
        movsb   
        xorl    %eax,%eax
        jmp     M1
N3:             
        andb    $31,%al
        movl    %eax,%ecx
        jnz     N6
        movb    $31,%cl
N4:             
        LODSB
        orb     %al,%al
        jnz     N5
        addl    N_255,%ecx
        jmp     N4  

        ALIGN3
N5:             
        addl    %eax,%ecx
N6:             
        movb    (%esi),%al
        incl    %esi

        movl    %eax,%ebx
        andb    $63,%al
        movl    %edi,%edx
        subl    %eax,%edx
        
        movb    (%esi),%al
        incl    %esi

        shll    $6,%eax
        subl    %eax,%edx
        cmpl    %edi,%edx
        jz      LEOF

        xchgl   %edx,%esi
        leal    3(%ecx),%ecx
        rep     
        movsb   

        movl    %edx,%esi
        xorl    %eax,%eax
        shrl    $6,%ebx
        movl    %ebx,%ecx
        jnz     LIT
        jmp     L1

LEOF:
/****   xorl    %eax,%eax          eax=0 from above */

        cmpl    $1,%ecx         /* ecx must be 1 */
        setnzb  %al


/*
vi:ts=4
*/

