unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls,
  dpmidas;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileOpenItem: TMenuItem;
    FileExitItem: TMenuItem;
    HelpContentsItem: TMenuItem;
    HelpSearchItem: TMenuItem;
    HelpHowToUseItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    StatusLine: TStatusBar;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    SpeedBar: TPanel;
    SpeedButton1: TSpeedButton;  { &Open... }
    SpeedButton2: TSpeedButton;  { &Contents }
    SpeedButton3: TSpeedButton;  { &About... }
    SpeedButton4: TSpeedButton;
    Close1: TMenuItem;  { E&xit }
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileNew(Sender: TObject);
    procedure FileOpen(Sender: TObject);
    procedure FileSave(Sender: TObject);
    procedure FileSaveAs(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure HelpContents(Sender: TObject);
    procedure HelpSearch(Sender: TObject);
    procedure HelpHowToUse(Sender: TObject);
    procedure HelpAbout(Sender: TObject);
  end;

var
  MainForm: TMainForm;
  playingMessage : string[64];

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  playingMessage := '';
  Application.OnHint := ShowHint;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  if Application.Hint <> '' then
    StatusLine.SimpleText := Application.Hint
  else
    StatusLine.SimpleText := playingMessage;
end;

procedure TMainForm.FileNew(Sender: TObject);
begin
  { Add code to create a new file }
end;

procedure TMainForm.FileOpen(Sender: TObject);
var
  cfilename : array[0..256] of char;
begin
  if OpenDialog.Execute then
  begin
    StrPCopy(cfilename, OpenDialog.FileName);
    StatusLine.SimpleText := 'Loading "' + OpenDialog.FileName + '"';
    LoadPlayModule(cfilename);
    playingMessage := 'Playing "' + info.songName + '"';
    StatusLine.SimpleText := playingMessage;
  end;
end;

procedure TMainForm.FileSave(Sender: TObject);
begin
   { Add code to save current file under current name }
end;

procedure TMainForm.FileSaveAs(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    { Add code to save current file under SaveDialog.FileName }
  end;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.HelpContents(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.HelpSearch(Sender: TObject);
const
  EmptyString: PChar = '';
begin
  Application.HelpCommand(HELP_PARTIALKEY, Longint(EmptyString));
end;

procedure TMainForm.HelpHowToUse(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TMainForm.HelpAbout(Sender: TObject);
begin
  Application.MessageBox('MIDAS DelphiPlayer v0.0.0', 'About DelphiPlayer',
    MB_OK);
  { Add code to show program's About Box }
end;

end.
