unit dpmidas;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls,
    midasdll;

var
    module : MIDASmodule;
    info : MIDASmoduleInfo;


procedure MIDASerror;
procedure InitMIDAS;
procedure LoadPlayModule(fileName : PChar);
procedure StopFreeModule;
procedure CloseMIDAS;


implementation


procedure MIDASerror;
var
    error : integer;
begin
    error := MIDASgetLastError;
    Application.MessageBox(MIDASgetErrorMessage(error), 'MIDAS error',
        MB_OK or MB_ICONSTOP);
    halt;
end;


procedure InitMIDAS;

begin
    if not MIDASinit then
        MIDASerror;
    if not MIDASstartPlayThread(0) then
        MIDASerror;
    module := NIL;
end;



procedure LoadPlayModule(fileName : PChar);

begin
    if module <> NIL then
        StopFreeModule;

    module := MIDASloadModule(fileName);
    if module = NIL then
        MIDASerror;

    if not MIDASplayModule(module, 0) then
        MIDASerror;

    if not MIDASgetModuleInfo(module, @info) then
        MIDASerror;
end;



procedure StopFreeModule;

begin
    if not MIDASstopModule(module) then
        MIDASerror;
    if not MIDASfreeModule(module) then
        MIDASerror;
    module := NIL;
end;



procedure CloseMIDAS;

begin
    if not MIDASstopPlayThread then
        MIDASerror;
    if not MIDASclose then
        MIDASerror;
end;



end.
