uses
    midasdll, sysutils;


procedure MIDASerror;
var
    error : integer;
begin
    error := MIDASgetLastError;
    WriteLn('MIDAS error: ', MIDASgetErrorMessage(error));
    MIDASclose;
    halt;
end;


var
    module : MIDASmodule;
    name : array[0..256] of char;


BEGIN
    WriteLn('Hauki');

    if ParamCount <> 1 then
    begin
        WriteLn('Usage: midastesti <filename>');
        exit;
    end;

    if not MIDASinit then
        MIDASerror;
    if not MIDASstartPlayThread(0) then
        MIDASerror;

    StrPCopy(name, ParamStr(1));
    module := MIDASloadModule(name);
    if module = NIL then
        MIDASerror;

    if not MIDASplayModule(module, 0) then
        MIDASerror;

    WriteLn('Playing - press enter');
    ReadLn;

    if not MIDASstopModule(module) then
        MIDASerror;
    if not MIDASfreeModule(module) then
        MIDASerror;
    if not MIDASstopPlayThread then
        MIDASerror;
    if not MIDASclose then
        MIDASerror;
END.
