#*      midasdll.mak
#*
#* Make script for MIDAS Sound System Win32 DLL
#*
#* $Id: midasdll.mak,v 1.1 1996/09/25 18:38:19 pekangas Exp $
#*
#* Copyright 1996 Petteri Kangaslampi and Jarno Paananen
#*
#* This file is part of the MIDAS Sound System, and may only be
#* used, modified and distributed under the terms of the MIDAS
#* Sound System license, LICENSE.TXT. By continuing to use,
#* modify or distribute this file you indicate that you have
#* read the license and understand and accept it fully.
#*

MIDASDIR = .
MIDASINCS = $(MIDASDIR)
MIDASLIB = $(MIDASDIR)\midasnt.lib


!ifdef VISUALC

CC = cl
CFLAGS =  -c -Zi -W3 -WX -YX -Zp1 -MT -nologo -O2 -Ot -G5 -D__VC32__ -DDEBUG \
        -DNOTIMER -DDLL_EXPORT -D__NT__

!else

CC = wcc386
CFLAGS = -w3 -d2 -we -oneatx -5r -bt=nt -mf -bd -i$(MIDASINCS) -d__WC32__ \
        -dDEBUG -dNOTIMER -dDLL_EXPORT

!endif


all :           midas05.dll midasdll.lib

!ifdef VISUALC

midasdll.lib midas05.dll :      midasdll.obj $(MIDASLIB)
        link /dll /debug /debugtype:cv /out:midas05.dll /implib:midasdll.lib \
                /machine:x86 midasdll.obj $(MIDASLIB) winmm.lib

!else

midasdll.lib :  midas05.dll
        wlib midasdll.lib +-midas05.dll

midas05.dll:            midasdll.obj $(MIDASLIB)
        wlink system nt dll debug all option caseexact option map name midas05 file midasdll library $(MIDASLIB)

!endif

midasdll.obj :          midasdll.c midasdll.h
        $(CC) $(CFLAGS) midasdll.c
