//////////////////////////////////////////////////////
// File: MatDemo2.cpp
// Purpose: Demonstrates use of matrix template class
// Author: Somnath Kundu

#include <complex>
#include "matrix.h"

#ifndef _NO_NAMESPACE
using namespace std;
using namespace math;
#endif

#ifndef _NO_TEMPLATE
typedef complex<double> type;
typedef matrix<type> Matrix;
#else
typedef matrix Matrix;
#endif

int main ()
{
   Matrix m(3,3),v(3,1),s(3,1);

   cout << "Solution of linear equation of complex number:\n\n";
   cout << "Enter the linear equations as (3X3) matrix:\n";
   cin >> m;
   cout << "Enter the vector as (3X1) matrix to solve it:\n";
   cin >> v;

   try
   {
      s = m.Solve(v);
   }
   catch (const exception e)
   {
      cout << "Error: " << e.what() << endl;
   }
   cout << "Solution:\n" << s << endl;

   return 0;
}

