/* lzo_asm.sh -- LZO assembler stuff

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the LZO library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */


/***********************************************************************
//
************************************************************************/

#if !defined(__i386__)
#  error
#endif


#ifndef _ALIGN
#define _ALIGN(x)			.align x,0x90
#endif

#if defined(__ELF__)
#  define LZO_PUBLIC(func)	.globl func ; func:
#  define ALIGN1			_ALIGN(2)
#  define ALIGN2			_ALIGN(4)
#  define ALIGN3			_ALIGN(8)
#else
#  define LZO_PUBLIC(func)	.globl _ ## func ; _ ## func:
#  define ALIGN1			_ALIGN(1)
#  define ALIGN2			_ALIGN(2)
#  define ALIGN3			_ALIGN(3)
#endif


/***********************************************************************
//
************************************************************************/

#ifndef INP
#define INP      4+24(%esp)
#define INS      8+24(%esp)
#define OUTP    12+24(%esp)
#define OUTS    16+24(%esp)
#endif


#if 0 && (defined(__linux__) || defined(__DJGPP__))
#  define INEND         (%esp)
#  define OUTEND        %ebp
#else
#  define INEND         4(%esp)
#  define OUTEND        (%esp)
#endif


#if 0
#undef LZO_TEST_DECOMPRESS_OVERRUN_INPUT
#define LZO_TEST_DECOMPRESS_OVERRUN_INPUT
#undef LZO_TEST_DECOMPRESS_OVERRUN_OUTPUT
#define LZO_TEST_DECOMPRESS_OVERRUN_OUTPUT
#undef LZO_TEST_DECOMPRESS_OVERRUN_LOOKBEHIND
#define LZO_TEST_DECOMPRESS_OVERRUN_LOOKBEHIND
#endif


#if defined(LZO_TEST_DECOMPRESS_OVERRUN_INPUT)
#  define TEST_IP_R(r)		cmpl r,INEND ; jb L_input_overrun
#  define TEST_IP(addr,r)	leal addr,r ; TEST_IP_R(r)
#else
#  define TEST_IP_R(r)
#  define TEST_IP(addr,r)
#endif

#if defined(LZO_TEST_DECOMPRESS_OVERRUN_OUTPUT)
#  define TEST_OP_R(r)		cmpl r,OUTEND ; jb L_output_overrun
#  define TEST_OP(addr,r)	leal addr,r ; TEST_OP_R(r)
#else
#  define TEST_OP_R(r)
#  define TEST_OP(addr,r)
#endif

#if defined(LZO_TEST_DECOMPRESS_OVERRUN_OUTPUT)
#  define TEST_LOOKBEHIND(r)	cmpl INP,r ; jb L_lookbehind_overrun
#else
#  define TEST_LOOKBEHIND(r)
#endif


#ifndef N_255
#  define N_255		$255
#endif


/***********************************************************************
//
************************************************************************/

#define LODSB			movb (%esi),%al ; incl %esi

#define MOVSB(r1,r2,x)  movb (r1),x ; incl r1 ; movb x,(r2) ; incl r2
#define MOVSW(r1,r2,x)  movb (r1),x ; movb x,(r2) ; \
                        movb 1(r1),x ; addl $2,r1 ; \
						movb x,1(r2) ; addl $2,r2
#define MOVSL(r1,r2,x)  movl (r1),x ; addl $4,r1 ; movl x,(r2) ; addl $4,r2

#if defined(LZO_DEBUG)
#define COPYB_C(r1,r2,x,rc) \
                        cmpl $0,rc ; jz L_error; \
                        cmpl INS,rc ; jae L_error; \
                        99: MOVSB(r1,r2,x) ; decl rc ; jnz 99b
#define COPYL_C(r1,r2,x,rc) \
                        cmpl $0,rc ; jz L_error; \
                        cmpl INS,rc ; jae L_error; \
                        99: MOVSL(r1,r2,x) ; decl rc ; jnz 99b
#else
#define COPYB_C(r1,r2,x,rc) \
                        99: MOVSB(r1,r2,x) ; decl rc ; jnz 99b
#define COPYL_C(r1,r2,x,rc) \
                        99: MOVSL(r1,r2,x) ; decl rc ; jnz 99b
#endif

#define COPYB(r1,r2,x)  COPYB_C(r1,r2,x,%ecx)
#define COPYL(r1,r2,x)  COPYL_C(r1,r2,x,%ecx)


/***********************************************************************
//
************************************************************************/

#if 0

#if 0
#define REP_MOVSB(x)    rep ; movsb
#define REP_MOVSL(x)    shrl $2,%ecx ; rep ; movsl
#elif 1
#define REP_MOVSB(x)    COPYB(%esi,%edi,x)
#define REP_MOVSL(x)    shrl $2,%ecx ; COPYL(%esi,%edi,x)
#else
#define REP_MOVSB(x)    rep ; movsb
#define REP_MOVSL(x)    jmp 96f ; 95: movsb ; decl %ecx ; \
						96: testl $3,%edi ; jnz 95b ; \
						movl %ecx,x ; shrl $2,%ecx ; andl $3,x ; \
						rep ; movsl ; movl x,%ecx ; rep ; movsb
#endif

#if 1
#define NEGL(x)         negl x
#else
#define NEGL(x)         xorl $-1,x ; incl x
#endif

#endif



/*
vi:ts=4
*/

