/* lzo1x_d.sh -- assembler implementation of the LZO1X decompression algorithm

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the LZO library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */


/*
 * This file has been adapted from code generously contributed by
 * Laszlo Molnar aka ML1050 <molnarl@postabank.hu>
 *
 * Many thanks, Laszlo !
 */


/***********************************************************************
// init
************************************************************************/

        xorl    %ebx,%ebx       /* bits 9-32 stay 0 */
        xorl    %eax,%eax
        LODSB
        cmpb    $17,%al
        jbe     L01
        subb    $17-3,%al
        jmp     LFLR


/***********************************************************************
// literal run
************************************************************************/

0:      addl    N_255,%eax
        TEST_IP(18(%esi,%eax),%edx)     /* minimum */
1:      movb    (%esi),%bl
        incl    %esi
        orb     %bl,%bl
        jz      0b
        leal    18+3(%eax,%ebx,1),%eax
        jmp     3f


        ALIGN3
L00:
#ifdef LZO_DEBUG
    andl $0xffffff00,%ebx ; jnz L_error
    andl $0xffffff00,%eax ; jnz L_error
    xorl %eax,%eax ; xorl %ebx,%ebx
    xorl %ecx,%ecx ; xorl %edx,%edx
#endif
        TEST_IP_R(%esi)
        LODSB
L01:
        cmpb    $16,%al
        jae     LMATCH

/* a literal run */
        orb     %al,%al
        jz      1b
        addl    $3+3,%eax
3:
LFLR:
        TEST_IP(-3(%esi,%eax,1),%edx)
        TEST_OP(-3(%edi,%eax,1),%edx)
        movl    %eax,%ecx
        shrl    $2,%ecx
#if 0
        rep
        movsl
#else
        COPYL(%esi,%edi,%edx)
#endif
        xorl    $-1,%eax
        andl    $3,%eax
        subl    %eax,%esi
        subl    %eax,%edi

#ifdef LZO_DEBUG
    andl $0xffffff00,%ebx ; jnz L_error
    andl $0xffffff00,%eax ; jnz L_error
    xorl %eax,%eax ; xorl %ebx,%ebx
    xorl %ecx,%ecx ; xorl %edx,%edx
#endif
        LODSB
        cmpb    $16,%al
        jae     LMATCH


/***********************************************************************
// R1
************************************************************************/

        TEST_OP(3(%edi),%edx)
        shrl    $2,%eax
        movb    (%esi),%bl
        leal    -0x801(%edi),%edx
        leal    (%eax,%ebx,4),%eax
        incl    %esi
        subl    %eax,%edx
        TEST_LOOKBEHIND(%edx)
        movl    (%edx),%ecx
        movl    %ecx,(%edi)
        addl    $3,%edi
        jmp     LMDONE


/***********************************************************************
// M2
************************************************************************/

        ALIGN3
LMATCH:
        cmpb    $64,%al
        jb      LM3MATCH

/* a M2 match */
        movl    %eax,%ecx
        shrl    $2,%eax
        leal    -1(%edi),%edx
        andl    $7,%eax
        movb    (%esi),%bl
        shrl    $5,%ecx
        leal    (%eax,%ebx,8),%eax
        incl    %esi
        subl    %eax,%edx
#if 0
        TEST_LOOKBEHIND(%edx)
        TEST_OP(1(%edi,%ecx,1),%eax)
        incl    %ecx
        xchgl   %edx,%esi
        rep
        movsb
        movl    %edx,%esi
        jmp     LMDONE
#elif 0
        TEST_LOOKBEHIND(%edx)
        TEST_OP(1(%edi,%ecx,1),%eax)
        decl    %ecx
        MOVSW(%edx,%edi,%al)
        COPYB(%edx,%edi,%al)
        jmp     LMDONE
#else
        addl    $4,%ecx
        cmpl    $3,%eax
        jae     LCOPYLONG
        jmp     LCOPYBYTE
#endif


/***********************************************************************
// M3
************************************************************************/

0:      addl    N_255,%eax
        TEST_IP(3(%esi),%edx)       /* minimum */
1:      movb    (%esi),%bl
        incl    %esi
        orb     %bl,%bl
        jz      0b
        leal    33+3(%eax,%ebx,1),%ecx
        xorl    %eax,%eax
        jmp     3f


        ALIGN3
LM3MATCH:
        cmpb    $32,%al
        jb      LM4MATCH

/* a M3 match */
        andl    $31,%eax
        jz      1b
        lea     2+3(%eax),%ecx
3:
#ifdef LZO_DEBUG
    andl $0xffff0000,%eax ; jnz L_error
#endif
        movw    (%esi),%ax
        leal    -1(%edi),%edx
        shrl    $2,%eax
        addl    $2,%esi
        subl    %eax,%edx

        cmpl    $3,%eax
        jb      LCOPYBYTE


/***********************************************************************
// copy match
************************************************************************/

        ALIGN1
LCOPYLONG:                      /* copy match using longwords */
        TEST_LOOKBEHIND(%edx)
        TEST_OP(-3(%edi,%ecx,1),%eax)
        movl    %ecx,%eax
        shrl    $2,%ecx
#if 0
        xchgl   %edx,%esi
        rep
        movsl
        movl    %edx,%esi
#else
        COPYL(%edx,%edi,%ebx)
        xorl    %ebx,%ebx
#endif
        xorl    $-1,%eax
        andl    $3,%eax
        subl    %eax,%edi


LMDONE:
        movb    -2(%esi),%al
        andl    $3,%eax
        jz      L00
        TEST_IP((%esi,%eax),%edx)
        TEST_OP((%edi,%eax),%edx)
        movl    (%esi),%edx
        addl    %eax,%esi
        movl    %edx,(%edi)
        addl    %eax,%edi
#ifdef LZO_DEBUG
    andl $0xffffff00,%ebx ; jnz L_error
    andl $0xffffff00,%eax ; jnz L_error
    xorl %eax,%eax ; xorl %ebx,%ebx
    xorl %ecx,%ecx ; xorl %edx,%edx
#endif
        LODSB
        jmp     LMATCH


        ALIGN3
LCOPYBYTE:                      /* copy match using bytes */
        TEST_LOOKBEHIND(%edx)
        TEST_OP(-3(%edi,%ecx,1),%eax)
#if 0
        subl    $5,%ecx
        MOVSW(%edx,%edi,%al)
        ALIGN1
        COPYB(%edx,%edi,%al)
#elif 0
        subl    $3,%ecx
        ALIGN1
        COPYB(%edx,%edi,%al)
#else
        subl    $3,%ecx
        xchgl   %edx,%esi
        rep
        movsb
        movl    %edx,%esi
#endif
        jmp     LMDONE


/***********************************************************************
// M4
************************************************************************/

0:      addl    N_255,%ecx
        TEST_IP(3(%esi),%edx)       /* minimum */
1:      movb    (%esi),%bl
        incl    %esi
        orb     %bl,%bl
        jz      0b
        leal    9+3(%ebx,%ecx,1),%ecx
        jmp     3f


        ALIGN3
LM4MATCH:
        cmpb    $16,%al
        jb      LM1MATCH

/* a M4 match */
        movl    %eax,%ecx
        andl    $8,%eax
        shll    $13,%eax        /* save in bit 16 */
        andl    $7,%ecx
        jz      1b
        addl    $2+3,%ecx
3:
#ifdef LZO_DEBUG
    movl %eax,%edx ; andl $0xfff80000,%edx ; jnz L_error
#endif
        movw    (%esi),%ax
        addl    $2,%esi
        leal    -0x4000(%edi),%edx
        shrl    $2,%eax
        jz      LEOF
        subl    %eax,%edx
        jmp     LCOPYLONG


/***********************************************************************
// M1
************************************************************************/

        ALIGN3
LM1MATCH:
/* a M1 match */
        TEST_OP(2(%edi),%edx)
        shrl    $2,%eax
        movb    (%esi),%bl
        leal    -1(%edi),%edx
        leal    (%eax,%ebx,4),%eax
        incl    %esi
        subl    %eax,%edx
        TEST_LOOKBEHIND(%edx)

        movb    (%edx),%al      /* we must use this because edx can be edi-1 */
        movb    %al,(%edi)
        movb    1(%edx),%al
        movb    %al,1(%edi)
        addl    $2,%edi
        jmp     LMDONE


/***********************************************************************
//
************************************************************************/

LEOF:
/****   xorl    %eax,%eax          eax=0 from above */

        cmpl    $6,%ecx         /* ecx must be 6 */
        setnzb  %al


/*
vi:ts=4
*/

