#
# libkb -- a free, advanced and portable low-level keyboard library
# Copyright (C) 1995, 1996 Markus Franz Xaver Johannes Oberhumer
# For conditions of distribution and use, see copyright notice in kb.h 
#

#
# this file is included by Makefile and Makefile.mfx
#

# /***********************************************************************
# // source, objects and executable files
# ************************************************************************/

SRCS := kbhandle.c kbmlock.c kbos.c kbsignal.c kbtables.c

OBJS := $(strip $(SRCS:.c=$O))


.PHONY: distexe

DISTEXE := bin/kbtstdos.exe bin/kbtstlnx.out

distexe: $(DISTEXE)


# /***********************************************************************
# // common useful targets
# ************************************************************************/

.PHONY: nm touch lsm grep

nm: nm-$(C)

nm-DJG nm-EMX nm-LNX nm-lnx nm-: $(LIBKB)
	nm --extern-only $<


touch:
	-$(TOUCH) -c -t 032300091996.00 * *.* */* *.*/*.*
#	                MMDDhhmmCCYY.ss


##lsm: $(DISTNAME).lsm
lsm: libkb.lsm

# rename lsm to current version
$(DISTNAME).lsm:
	-$(REN) *.lsm $@


UPPER_MAKE := Makefile Makefile.inc Makefile.mfx
### Makefile.bcc Makefile.djg Makefile.wcc

UPPER_FILE := CHANGE.LOG COPYING.KB DESC.SDI FILE_ID.DIZ KB.DOC README.1ST


grep:
	-mfxgrep -lc   '\t' $(UPPER_FILE) include/kb.h
	-mfxgrep -lcrB '\r' 
	-mfxgrep -Lcri 'oberhumer' 


# /***********************************************************************
# // Dependencies and special rules
# ************************************************************************/

_kbtable.hh: mktables$E
	$< > $@

kbhandle$O: kbhandle.c _kblinux.h _kbmsdos.h 
kbtables$O: kbtables.c _kbtable.hh _kbname.hh
kbtst$O: kbtst.c myconio.h

