#ifndef __QUANTIZ2_H
#define __QUANTIZ2_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <go32.h>
#include <sys/farptr.h>
#include <dos.h>

#define putpixel(x, y, c) _farpokeb(_dos_ds, 0xA0000+(y)*320+(x), (c))

#define RS2 32
#define GS2 32
#define BS2 32
#define CS2 RS2*GS2*BS2

#define RGB2(r,g,b) ((r)*GS2*BS2+(g)*BS2+(b))
#define R2(c) (((c)/GS2/BS2) & (RS2-1))
#define G2(c) (((c)/BS2) & (GS2-1))
#define B2(c) ((c) & (BS2-1))

#define MAXVARIANCE 0

typedef struct {
    unsigned char r;
    unsigned char g;
    unsigned char b;
    unsigned long count;
} COLOR;

void InitQuantization2(int WantedColors);
void DeinitQuantization2(int WantedColors);

unsigned char *Quantisize2(int WantedColors, unsigned char *Cube);
void AddImage2(unsigned char *Buffer, unsigned char *Palette, int bytes);

unsigned char Nearest(int r, int g, int b, int Wanted);
inline unsigned long Dist(int r1, int g1, int b1, int r2, int g2, int b2);
void *Jmalloc(size_t size);
void SetPalette(unsigned char *Palette);
void LoadPCX(char *Filename, unsigned char *Buffer, unsigned char *Palette);
void Display(unsigned char *Image1, unsigned char *Image2,
             unsigned char *Palette1, unsigned char *Palette2,
             unsigned char *PaletteArray);

#endif
