#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <go32.h>
#include <sys/movedata.h>
#include <pc.h>

#include "palette.h"

#define flip(c) _dosmemputl(c, 16000, 0xA0000)

void genpal(char *palette) {
    char r=0, g=0, b=0;
    int c, color=0;
    
    for(c=0; c<64; c++) { /* MUSTA (0,0,0) - PUNAINEN (63,0,0) */
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(r<63) r++;
    }
    for(c=0; c<64; c++) { /* PUNAINEN (63,0,0) - VIOLETTI (63,0,63) */
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(b<63) b++;
    }
    for(c=0; c<64; c++) { /* VIOLETTI (63,0,63) - VALKOINEN (63,63,63) */
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(g<63) g++;
    }
    for(c=0; c<64; c++) { /* VALKOINEN (63, 63, 63) - MUSTA (0,0,0) */
        palette[color++]=r;
        palette[color++]=g;
        palette[color++]=b;
        if(r) r--;
        if(g) g--;
        if(b) b--;
    }
}

int main() {
  int loop, x, y;
  float wave1[256], wave2[256], wave3[256], 
        wave4[256], wave5[256], wave6[256];
  unsigned char ind1, ind2, ind3, ind4, ind5, ind6;
  unsigned char dblbuf[64000];
  char palette[768];

  for(loop=0; loop<256; loop++) {
    wave1[loop]=cos(3.1415*2* (float) loop             /256) * 25.0 + 25.0;
    wave2[loop]=cos(3.1415*2* (float) (loop%128)       /128) * 15.0 + 15.0;
    wave3[loop]=cos(3.1415*2* (float) (255-loop)       /256) * 17.5 + 17.5;
    wave4[loop]=sin(3.1415*2* (float) (loop%64)         /64) * 22.5 + 22.5;
    wave5[loop]=cos(3.1415*2* (float) ((128-loop)%128) /128) * 20.0 + 20.0;
    wave6[loop]=sin(3.1415*2* (float) loop             /256) * 25.0 + 25.0;
  }

  textmode(0x13);
  genpal(palette);
  setpal(palette);

  ind1=100;
  ind2=200;
  ind3=0;
  ind4=50;
  ind5=12;
  ind6=150;
  while(!kbhit()) {
    for(x=0; x<320; x++) for(y=0; y<200; y++) {
      dblbuf[y*320+x] = 
        (int)(wave1[ ( ind1 + x ) & 0xFF ]+
              wave2[ ( ind2 + x ) & 0xFF ]+
              wave3[ ( ind3 + x ) & 0xFF ]+
              wave4[ ( ind4 + y ) & 0xFF ]+
              wave5[ ( ind5 + y ) & 0xFF ]+
              wave6[ ( ind6 + y ) & 0xFF ]);
    }
    flip(dblbuf);
    ind1++;
    ind2++;
    ind3--;
    ind4++;
    ind5--;
    ind6--;
  }
  getch();
  textmode(0x03);

  return 0;
}
