#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <go32.h>
#include <sys/farptr.h>

#define putpixel(x, y, c) _farpokeb(_dos_ds, 0xA0000+(y)*320+(x), (c))

#define REDSHADES 64    /* Vlill 2-256, kiitos! */
#define GREENSHADES 64  /* Vlill 2-256, kiitos! */
#define BLUESHADES 64   /* Vlill 2-256, kiitos! */

#define REDBITS 6
#define GREENBITS 6
#define BLUEBITS 6

/* Makrot vrikomponenttien skaalaamiseen oikeaksi */
#define ScaleRed(r, max) (max < REDSHADES ? r*(REDSHADES/max) : r/(max/REDSHADES))
#define ScaleGreen(g, max) (max < GREENSHADES ? g*(GREENSHADES/max) : g/(max/GREENSHADES))
#define ScaleBlue(b, max) (max < BLUESHADES ? b*(BLUESHADES/max) : b/(max/BLUESHADES))

/* Makro sijainnin laittamiseen */
#define RGBIndex(r,g,b) (long) ( ((long)(r) *GREENSHADES*BLUESHADES)+((long)(g)*BLUESHADES)+(long)(b) )

/* Makrot vrikomponenttien purkamiseen sijainnista */
#define GetRedFromIndex(i)   (((i)/GREENSHADES/BLUESHADES) &(REDSHADES-1))
#define GetGreenFromIndex(i) (((i)/BLUESHADES)             &(GREENSHADES-1))
#define GetBlueFromIndex(i)  (((i))                        &(BLUESHADES-1))

typedef struct {
    int RedSubspaceBottom;
    int GreenSubspaceBottom;
    int BlueSubspaceBottom;
    int RedSubspaceTop;
    int GreenSubspaceTop;
    int BlueSubspaceTop;

    int OptimalRed;
    int OptimalGreen;
    int OptimalBlue;
} BORDERS;

unsigned char *Quantisize(unsigned char *PaletteArray, int WantedColors);

void DivideCubes(unsigned char *TripletTable, int PaletteTriplets, BORDERS Borders,
                 int RecursionLevel, BORDERS *BorderTable, int *TablesUsed);

void LoadPCX(char *Filename, unsigned char *Buffer, unsigned char *Palette);

void IncludePalette(unsigned char *Palette, unsigned char *PaletteArray);

void Display(unsigned char *Image1, unsigned char *Image2,
             unsigned char *Palette1, unsigned char *Palette2,
             unsigned char *PaletteArray);

void SetPalette(unsigned char *Palette);

int main() {
    unsigned char Palette1[768], Palette2[768],
        Image1[256*256], Image2[256*256];
    unsigned char *PaletteArray=(unsigned char *)malloc(REDSHADES*GREENSHADES*BLUESHADES);
    unsigned char *OptimalPalette;

    if(PaletteArray==NULL)
        return 1;

    textmode(0x13);
    memset(PaletteArray, 0, REDSHADES*GREENSHADES*BLUESHADES);
    LoadPCX("QESIM1.PCX", Image1, Palette1);
    LoadPCX("QESIM2.PCX", Image2, Palette2);
    IncludePalette(Palette1, PaletteArray);
    IncludePalette(Palette2, PaletteArray);
    OptimalPalette=Quantisize(PaletteArray, 256);
    SetPalette(OptimalPalette);
    free(OptimalPalette);
    Display(Image1, Image2, Palette1, Palette2, PaletteArray);
    getch();
    textmode(0x03);
    return 0;
}

/* Quantisize muuttaa PaletteArrayn nit vrej generoidussa paletissa
   vastaaviksi indekseiksi. Toiminta on seuraava:

   Otetaan WantedColors ja muutetaan se rekursiotasoiksi. Teso valitaan
   siten, ett 2^Rekursiotaso tuottaa tulokseksi WantedColorsin, eli
   ollen pit tuon arvon olla jokin kahden potenssi.

   Lisksi funktio varaa muistin BorderTablelle jonne Quantisize-rutiini
   toimittaa jaettujen vrikuutioiden rajat.

   Sen jlkeen ohjelma tekee taulukon joka sislt PaletteArrayss
   vaaditut vrit (ilmoitettu arvolla 1 vriarvosta muodostetun indeksin
   kohdalla taulukossa) ja kutsuu DivideCubes-rutiinia lasketulla
   rekursiotasolla ja maksimirajoilla sorttaamaan tmn taulukon.

   DivideCubes-rutiinin palattua funktio tytt PaletteArrayn vriavaruuden
   looppaamalla BorderTablet lpi ja tyttmll niiden Subspace-muuttujien
   kertomat kuutiot BorderTablen numerolla ja asettamalla numeron
   ilmoittaman vrin paletista Optimal-muuttujien ilmoittamaan vriin.

   Lopuksi vapautetaan turha kulutettu muisti ja poistutaan rutiinista,
   palauttaen vastaluotu paletti, kaikki on valmista.
   */
unsigned char *Quantisize(unsigned char *PaletteArray, int WantedColors) {
    int RecursionLevel, PaletteTriplets=0, TablesUsed=0, loop, c, r, g, b;
    BORDERS *BorderTable=(BORDERS *)malloc(sizeof(BORDERS)*WantedColors),
            Borders= {0, 0, 0, 63, 63, 63, 32, 32, 32};
    unsigned char *TripletTable, *Palette=(unsigned char *)malloc(768);

    if(BorderTable==NULL || Palette==NULL) {
        puts("Not enough memory for palette quantisizing!");
        exit(1);
    }

    for(loop=0; loop<REDSHADES*GREENSHADES*BLUESHADES; loop++)
        if(PaletteArray[loop])
            PaletteTriplets++;
    for(RecursionLevel=0, loop=1;
        loop<WantedColors;
        loop*=2, RecursionLevel++);

    TripletTable=(unsigned char *)malloc(PaletteTriplets*3);
    if(TripletTable==NULL) {
        puts("Not enough memory for palette quantisizing!");
        exit(1);
    }

    for(loop=c=0; loop<REDSHADES*GREENSHADES*BLUESHADES; loop++) {
        if(PaletteArray[loop]) {
            TripletTable[c++]=GetRedFromIndex(loop);
            TripletTable[c++]=GetGreenFromIndex(loop);
            TripletTable[c++]=GetBlueFromIndex(loop);
        }
    }
    DivideCubes(TripletTable, PaletteTriplets, Borders, RecursionLevel,
                BorderTable, &TablesUsed);

    for(loop=0; loop<TablesUsed; loop++) {
        for(r=BorderTable[loop].RedSubspaceBottom;
            r<=BorderTable[loop].RedSubspaceTop;
            r++)
        for(g=BorderTable[loop].GreenSubspaceBottom;
            g<=BorderTable[loop].GreenSubspaceTop;
            g++)
        for(b=BorderTable[loop].BlueSubspaceBottom;
            b<=BorderTable[loop].BlueSubspaceTop;
            b++)
        PaletteArray[RGBIndex(r, g, b)]=loop;
        Palette[loop*3+0]=BorderTable[loop].OptimalRed;
        Palette[loop*3+1]=BorderTable[loop].OptimalGreen;
        Palette[loop*3+2]=BorderTable[loop].OptimalBlue;
    }

    for(; loop<WantedColors; loop++) {
        Palette[loop*3+0]=0;
        Palette[loop*3+1]=0;
        Palette[loop*3+2]=0;
    }

    free(BorderTable);
    free(TripletTable);

    return Palette;
}

/* DivideCubes on rekursiivinen funktio jonka tehtv on jakaa vriavaruus
   pienempiin kuutioihin. Jokainen kutsukerta jakaa sille annetun
   aliavaruuden kahtia ja kutsuu itsen kummallekin puoliskolle jos
   rekursioarvo on suurempi kuin 0. Muutoin tm asettaa yhden BorderTablen
   arvon omiin parametreina annettuihin aliavaruus-arvoihinsa ja korottaa
   Tablesused-muuttujaa yhdell. Ja kuten tuosta huomataan tytyy funktion
   huolehtia oikeat tiedot sisltv BORDERS-rakenne itselleen. Tarkemmin
   kuvattuna ohjelma tekee seuraavat tehtvt:

   Laskee aliavaruutensa uloimmaiset vrit ja jakaa aliavaruuden pisimmn
   vriakselietisyyden mukaan siten, ett molempaan puoliskoon tulee yht
   monta tmn vriakselin alkiota.

   Eli lasketaan kunkin vriarvon mr ja loopataan lpi alustaen kunkin
   vriarvon mrn sisltv taulukko uusiksi siten, ett taulukko sislt
   "alkioita thn menness"-laskurin. Lopuksi otetaan alkioiden yhteismr
   viimeisest alkiosta ja jaetaan se kahdella ja katsotaan mist kohtaa
   pit ptkist.

   Alustetaan Borders-rakenteen vastaava Optimal-muuttuja tksi arvoksi sek
   Subspace-muuttujat uloimmaisten vrien sijainnin mukaan. Tarkistetaan
   rekursiotaso ja jos se on nolla niin sijoitetaan Borders-rakenne
   BorderTable-taulukkoon ja korotetaan TablesUsed-muuttujaa yhdell.

   Jos rekursiota viel riitt niin katsotaan taulukosta
   palettitriplettien mrt molemmille puoliskoille ja alustetaan kummankin
   puoliskon BORDERS-muuttujat kytten apuna taulukkoa ja aiempaa Borders-
   rakennetta. Sitten vain kutsutaan molempia ja lopetetaan.
*/
void DivideCubes(unsigned char *TripletTable, int PaletteTriplets,
                 BORDERS Borders, int RecursionLevel, BORDERS *BorderTable,
                 int *TablesUsed) {
    int RedCount[REDSHADES], GreenCount[GREENSHADES], BlueCount[BLUESHADES];
    int loop, sr=REDSHADES, br=0, sg=GREENSHADES, bg=0, sb=BLUESHADES, bb=0;
    int red, green, blue;
    BORDERS A, B;

    memset(RedCount, 0, REDSHADES*sizeof(int));
    memset(GreenCount, 0, GREENSHADES*sizeof(int));
    memset(BlueCount, 0, BLUESHADES*sizeof(int));

    for(loop=0; loop<PaletteTriplets; loop++) {
        red=TripletTable[loop*3+0];
        green=TripletTable[loop*3+1];
        blue=TripletTable[loop*3+2];
        if(red>=Borders.RedSubspaceBottom && red<=Borders.RedSubspaceTop &&
           green>=Borders.GreenSubspaceBottom && green<=Borders.GreenSubspaceTop &&
           blue>=Borders.BlueSubspaceBottom && blue<=Borders.BlueSubspaceTop) {

            RedCount[red]++;
            if(red>br) br=red;
            if(red<sr) sr=red;

            GreenCount[green]++;
            if(green>bg) bg=green;
            if(green<sg) sg=green;

            BlueCount[blue]++;
            if(blue>bb) bb=blue;
            if(blue<sb) sb=blue;

        }
    }

    for(loop=1; loop<REDSHADES; loop++)
        RedCount[loop]+=RedCount[loop-1];
    for(loop=1; loop<GREENSHADES; loop++)
        GreenCount[loop]+=GreenCount[loop-1];
    for(loop=1; loop<BLUESHADES; loop++)
        BlueCount[loop]+=BlueCount[loop-1];

    red=RedCount[REDSHADES-1]/2;
    green=GreenCount[GREENSHADES-1]/2;
    blue=BlueCount[BLUESHADES-1]/2;

    for(loop=0; loop<REDSHADES-1; loop++) {
        if(RedCount[loop+1]>red) {
            Borders.OptimalRed=loop;
            break;
        }
    }

    for(loop=0; loop<GREENSHADES-1; loop++) {
        if(GreenCount[loop+1]>green) {
            Borders.OptimalGreen=loop;
            break;
        }
    }

    for(loop=0; loop<BLUESHADES-1; loop++) {
        if(BlueCount[loop+1]>blue) {
            Borders.OptimalBlue=loop;
            break;
        }
    }

    if(RecursionLevel==0 || red==0) {
        memcpy(&BorderTable[TablesUsed[0]], &Borders, sizeof(BORDERS));
        TablesUsed[0]++;
    } else {
        memcpy(&A, &Borders, sizeof(BORDERS));
        memcpy(&B, &Borders, sizeof(BORDERS));

        red=br-sr;
        green=bg-sg;
        blue=bb-sb;
        if(red>=green && red>=blue) {
            A.RedSubspaceTop=Borders.OptimalRed;
            B.RedSubspaceBottom=Borders.OptimalRed+1;
        } else if(green>=red && green>=blue) {
            A.GreenSubspaceTop=Borders.OptimalGreen;
            B.GreenSubspaceBottom=Borders.OptimalGreen+1;
        } else if(blue>=red && blue>=green) {
            A.BlueSubspaceTop=Borders.OptimalBlue+1;
            B.BlueSubspaceBottom=Borders.OptimalBlue;
        }
        DivideCubes(TripletTable, PaletteTriplets, A, RecursionLevel-1,
                    BorderTable, TablesUsed);
        DivideCubes(TripletTable, PaletteTriplets, B, RecursionLevel-1,
                    BorderTable, TablesUsed);
    }
}

/* LoadPCX lataa normaalisti 256-vrisen PCX-kuvan paletteineen */
void LoadPCX(char *Filename, unsigned char *Buffer, unsigned char *Palette) {
    FILE *handle=fopen(Filename, "rb");
    unsigned long tavu,tavu2, c, maxx, maxy;

    if(handle==NULL) {
        puts("Can't open PCX file!");
        exit(1);
    }

    fseek(handle,8,SEEK_SET);
    maxx=fgetc(handle) + (fgetc(handle) << 8) +1;
    maxy=fgetc(handle) + (fgetc(handle) << 8) +1;

    fseek(handle,128,SEEK_SET);
    for(c=0; c<maxy*maxx;) {
        tavu=fgetc(handle);
        if(tavu>192) {
            tavu2=fgetc(handle);
            for(;tavu>192;tavu--)
	            Buffer[c++]=tavu2;
        } else Buffer[c++]=tavu;
    }
    fseek(handle, -768, SEEK_END);

    for(c=0; c<768; c++) {
        Palette[c]=fgetc(handle)/4;
    }

    fclose(handle);
}

/* IncludePalette merkkaa paletin Palette sisltmt vritripletit
   kytetyiksi vritaulukossa PaletteArray */
void IncludePalette(unsigned char *Palette, unsigned char *PaletteArray) {
    int loop, r, g, b;

    for(loop=0; loop<256; loop++) {
        r=Palette[loop*3+0];
        g=Palette[loop*3+1];
        b=Palette[loop*3+2];
        PaletteArray[RGBIndex(r,g,b)]=1;
    }
}

/* Display on nopeasti kokoonkyhtty funktio kahden 256*256 kuvan
   nyttmiseksi VGA:n ruudulla kytten kvantisoitua palettia */
void Display(unsigned char *Image1, unsigned char *Image2,
             unsigned char *Palette1, unsigned char *Palette2,
             unsigned char *PaletteArray) {
    int loop1, loop2, color, r, g, b;

    for(loop1=0; loop1<200; loop1++) {
        for(loop2=0; loop2<160; loop2++) {
            color=Image1[loop1*256+loop2];
            r=Palette1[color*3+0];
            g=Palette1[color*3+1];
            b=Palette1[color*3+2];
            color=PaletteArray[RGBIndex(r,g,b)];

            putpixel(loop2, loop1, color);
        }
        for(loop2=0; loop2<160; loop2++) {
            color=Image2[loop1*256+loop2];
            r=Palette2[color*3+0];
            g=Palette2[color*3+1];
            b=Palette2[color*3+2];
            color=PaletteArray[RGBIndex(r,g,b)];

            putpixel(loop2+160, loop1, color);
        }
    }
}

/* Asettaa halutun paletin */
void SetPalette(unsigned char *Palette) {
    int c;

    outportb(0x3C8, 0);
    for(c=0; c<256*3; c++)
        outportb(0x3C9, Palette[c]);
}
