#include <dos.h>

#define idxbyte(v, p)	((char *)&v)[p]
#define dspwrite(val)	while (inportb(sbbase + 0xC) & 0x80) ; \
			outportb(sbbase + 0xC, val)

int	sbbase;
int	sbirq;
int	sbdma;

int	bufplaying;
int	bufoverlap;
int	bufempty[2];
int	buflength[2];
long	bufaddress[2];

int	pageregs[] = {0x87, 0x83, 0x81, 0x82};
int	baseregs[] = {0, 2, 4, 6};
int	countregs[] = {1, 3, 5, 7};

void interrupt	sbhandler(void);
void interrupt	(*oldirq)();

int
sbinit(int base, int irq, int dma)
{
	sbbase = base;
	sbirq = irq;
	sbdma = dma;

	outportb(sbbase + 6, 1);
	inportb(sbbase + 6);
	inportb(sbbase + 6);
	inportb(sbbase + 6);
	inportb(sbbase + 6);
	inportb(sbbase + 6);
	inportb(sbbase + 6);
	outportb(sbbase + 6, 0);

	for (irq = 0; irq < 100; irq++)
		if (inportb(sbbase + 0xA) == 0xAA) {
			oldirq = getvect(sbirq + 8);
			setvect(sbirq + 8, sbhandler);
			outportb(0x21, inportb(0x21) & ~(1 << sbirq));
			dspwrite(0xD1);
			return 1;
		}

	return 0;
}

int
sbrate(int frequency)
{
	if (5000 <= frequency && frequency <= 22000) {
		frequency = 1000000L / frequency;
		dspwrite(0x40);
		dspwrite(256 - frequency);
		return 1000000L / frequency;
	} else
		return 0;
}

void
sbdblbuf(char * one, int len1, char * two, int len2)
{
	bufplaying = 0;
	bufoverlap = 0;
	bufempty[0] = 0;
	bufempty[1] = 0;
	buflength[0] = len1-1;
	buflength[1] = len2-1;
	bufaddress[0] = FP_SEG(one) * 16L + FP_OFF(one);
	bufaddress[1] = FP_SEG(two) * 16L + FP_OFF(two);

	outportb(0xA, sbdma + 4);
	outportb(0xC, sbdma + 0);
	outportb(0xB, sbdma + 0x48);
	outportb(baseregs[sbdma], idxbyte(bufaddress[bufplaying], 0));
	outportb(baseregs[sbdma], idxbyte(bufaddress[bufplaying], 1));
	outportb(pageregs[sbdma], idxbyte(bufaddress[bufplaying], 2));
	outportb(countregs[sbdma], idxbyte(buflength[bufplaying], 0));
	outportb(countregs[sbdma], idxbyte(buflength[bufplaying], 1));
	outportb(0xA, sbdma + 0);
	dspwrite(0x14);
	dspwrite(idxbyte(buflength[bufplaying], 0));
	dspwrite(idxbyte(buflength[bufplaying], 1));
}

void
sbstop(void)
{
	inportb(sbbase + 0xE);
	outportb(0x20, 0x20);
	outportb(0x21, inportb(0x21) | (1 << sbirq));
	setvect(sbirq + 8, oldirq);
}

void interrupt
sbhandler(void)
{
	bufempty[bufplaying] = 1;
	bufplaying ^= 1;
	if (bufempty[bufplaying]) bufoverlap = 1;

	outportb(0xA, sbdma + 4);
	outportb(0xC, sbdma + 0);
	outportb(0xB, sbdma + 0x48);
	outportb(baseregs[sbdma], idxbyte(bufaddress[bufplaying], 0));
	outportb(baseregs[sbdma], idxbyte(bufaddress[bufplaying], 1));
	outportb(pageregs[sbdma], idxbyte(bufaddress[bufplaying], 2));
	outportb(countregs[sbdma], idxbyte(buflength[bufplaying], 0));
	outportb(countregs[sbdma], idxbyte(buflength[bufplaying], 1));
	outportb(0xA, sbdma + 0);
	dspwrite(0x14);
	dspwrite(idxbyte(buflength[bufplaying], 0));
	dspwrite(idxbyte(buflength[bufplaying], 1));

	inportb(sbbase + 0xE);
	outportb(0x20, 0x20);
}
