/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * X Version Copyright (C) 1995 Mike Manley
 * Minor bugfixes/enhancements 1996 by Henrik Schmidt 
 * Small changes/bugfixes 1997 by Jon Griffiths
 * Based on SVGA code by Jonathan Paul Griffiths
 */
#include <jlib.h>

#define BR buffer_rec

extern void __target_buff_free(buffer_rec *buff);
extern void __target_buff_init(buffer_rec *buff);


/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
void screen_blit_fs_buffer(BR *d)
{
	JLIB_ENTER("screen_blit_fs_buffer");

#ifndef JLIB_PRODUCTION
	if(!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
	jlib_check_buffer(d);
#endif

	if (d->bimage == NULL)
		__target_buff_init(d);

	/* Put to window */
	XPutImage(jxdisplay, jxwindow, jxgc, d->bimage , 0, 0, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_toNC(int x, int y, BR *d, int x1, int y1, int x2, int y2)
{
	JLIB_ENTER("screen_blit_buff_toNC");
	
#ifndef JLIB_PRODUCTION
	if(!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	if (d->bimage == NULL)
		__target_buff_init(d);

	if (x1 > x2) JLIB_SWAP(x1, x2);
	if (y1 > y2) JLIB_SWAP(y1, y2);

	XPutImage(jxdisplay, jxwindow, jxgc, d->bimage, x1, y1, x, y, x2 - x1 + 1 , y2 - y1 + 1);
	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_to(int x, int y, BR *d, int x1, int y1, int x2, int y2)
{
	int width, height;

	JLIB_ENTER("screen_blit_buff_to");

#ifndef JLIB_PRODUCTION
	if(!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
	jlib_check_buffer(d);
#endif

	if (d->bimage == NULL)
		__target_buff_init(d);

	if (x1 > x2) JLIB_SWAP(x1, x2);
	if (y1 > y2) JLIB_SWAP(y1, y2);

	/* clip src buffer */
	if (x1 < B_CX1(d)) {
		x += (B_CX1(d) - x1);
		x1 = B_CX1(d);
	}
	else
		if (x1 > B_CX2(d)) {
			JLIB_LEAVE;
			return;
		}

	if (x2 > B_CX2(d))
		x2 = B_CX2(d);
	else
		if (x2 < B_CX1(d)) {
			JLIB_LEAVE;
			return;
		}

	if (y1 < B_CY1(d)) {
		y += (B_CY1(d) - y1);
		y1 = B_CY1(d);
	}
	else
		if (y1 > B_CY2(d)) {
			JLIB_LEAVE;
			return;
		}

	if (y2 > B_CY2(d))
		y2 = B_CY2(d);
	else
		if (y2 < B_CY1(d)) {
			JLIB_LEAVE;
			return;
		}

	height = y2 - y1 + 1;
	width = x2 - x1 + 1;

	/* clip dest */
	if (x < 0) {
		x1 -= x;
		if (x1 > B_CX2(d)) {
			JLIB_LEAVE;
			return;
		}
		x = 0;
	}
	else
		if (x > SCREEN_MAX_X) {
			JLIB_LEAVE;
			return;
		}

	if (x + width > SCREEN_MAX_X) {
		/* clip src */
		width = SCREEN_MAX_X - x + 1;
	}
	else
		if (x + width < 0) {
			JLIB_LEAVE;
			return;
		}

	if (y < 0) {
		y1 -= y;
		if (y1 > B_CY2(d)) {
			JLIB_LEAVE;
			return;
		}
		height += y;
		y = 0;
	}
	else
		if (y > SCREEN_MAX_Y) {
			JLIB_LEAVE;
			return;
		}

	if (y + height > SCREEN_MAX_Y) {
		/* clip src */
		height = SCREEN_MAX_Y - y + 1;
	
	}
	else
		if (y + height < 0) {
			JLIB_LEAVE;
			return;
		}

	XPutImage(jxdisplay, jxwindow, jxgc, d->bimage, x1, y1, x, y, x2 - x1 + 1, y2 - y1 + 1);

	JLIB_LEAVE;
}