/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>
#include <stdio.h>
#include <dos.h>
#include <ctype.h>

#define FOR_WATCOM 1
#include "..\comm\comm_key.c"

void (__interrupt __far * oldkeyhandler) ();

/*+------------------------------------------------------------------------+ */
/*| Initialise the keyboard.                                               | */
/*+------------------------------------------------------------------------+ */
void kb_init(void)
{
	if (__jlib_kb_initted) {
		return;
	}
	__jlib_kb_initted = 1;
	kb_clear();

	oldkeyhandler = _dos_getvect(0x9);
	_dos_setvect(0x9, __jlib_keyint);
}


/*+------------------------------------------------------------------------+ */
/*| Shut down the keyboard.                                                | */
/*+------------------------------------------------------------------------+ */
void kb_closedown(void)
{
	if (!__jlib_kb_initted) {
		return;
	}
	__jlib_kb_initted = 0;

	_dos_setvect(9, oldkeyhandler);
}
