
#ifdef __GNUC__
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <jlib.h>

struct timeval *jlib_timeval = NULL;


void uclock_init(void)
{
	if (jlib_timeval == NULL) {
		jlib_timeval = (struct timeval *) malloc(sizeof(struct timeval));
		if (jlib_timeval == NULL) {
			jlib_exit(jlib_msg(JLIB_EMALLOC));
		}
	}
}


unsigned int uclock_read(void)
{
	if (jlib_timeval != NULL) {
		gettimeofday(jlib_timeval, NULL);
		/* "<< 20" gives us a multiply by 1048576, close enuf to 1 million for me */
		return (((unsigned int) jlib_timeval->tv_sec << 20) + ((unsigned int) jlib_timeval->tv_usec));
	}
	return 0;
}
#endif
