/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <stdlib.h>
#include <vgakeyboard.h>
#include <linux/keyboard.h>

#define FOR_LINUX
#include "../comm/comm_key.c"

static void __jlib_keyint(int scancode, int newstate);

/*+------------------------------------------------------------------------+ */
/*| Initialise the keyboard.                                               | */
/*+------------------------------------------------------------------------+ */
void kb_init(void)
{
	if (__jlib_kb_initted)
		return;

	__jlib_kb_initted = 1;

	if (keyboard_init())
		jlib_exit(jlib_msg(JLIB_EKB));

	keyboard_seteventhandler(__jlib_keyint);
	kb_clear();
}


/*+------------------------------------------------------------------------+ */
/*| Shut down the keyboard.                                                | */
/*+------------------------------------------------------------------------+ */
void kb_closedown(void)
{
	if (!__jlib_kb_initted)
		return;

	__jlib_kb_initted = 0;

	keyboard_close();
}


/* our key handler */
static void __jlib_keyint(int scancode, int newstate)
{
	if (scancode < 0 || scancode >= NR_KEYS)
		return;

	if ((scancode == 58) && (!newstate)) {	/* caps lock released */
		__jlib_caps_state = (!__jlib_caps_state);	/* flip shift state */
	}
	/* map cursor keys */
	switch (scancode) {
	case SCANCODE_CURSORBLOCKUP:
		scancode = SCANCODE_CURSORUP;
		break;
	case SCANCODE_CURSORBLOCKLEFT:
		scancode = SCANCODE_CURSORLEFT;
		break;
	case SCANCODE_CURSORBLOCKRIGHT:
		scancode = SCANCODE_CURSORRIGHT;
		break;
	case SCANCODE_CURSORBLOCKDOWN:
		scancode = SCANCODE_CURSORDOWN;
		break;
	}

	/* set state to reflect newstate */
	__jlib_kb_state[scancode] = newstate;

	if (newstate) {		/* key pressed */
		if (__jlib_ascii_tab[scancode]) {
			if (__jlib_caps_state) {
				buff_add(__jlib_caps_tab[scancode]);
			} else {
				if ((__jlib_kb_state[KEY_LSHIFT]) || (__jlib_kb_state[KEY_RSHIFT])) {
					buff_add(__jlib_shift_tab[scancode]);
				} else {
					buff_add(__jlib_ascii_tab[scancode]);
				}
			}
		} else {
			switch (scancode) {
			case KEY_CAPSLOCK:
				__jlib_caps_state = (!__jlib_caps_state);	/* flip shift state */
				break;
			case KEY_LSHIFT:
				buff_add(KB_LSHIFT);
				break;
			case KEY_RSHIFT:
				buff_add(KB_RSHIFT);
				break;
			case KEY_CONTROL:
				buff_add(KB_CTRL);
				break;
			case KEY_ALT:
				buff_add(KB_ALT);
				break;
			case KEY_UP:
				buff_add(KB_UP);
				break;
			case KEY_DOWN:
				buff_add(KB_DOWN);
				break;
			case KEY_LEFT:
				buff_add(KB_LEFT);
				break;
			case KEY_RIGHT:
				buff_add(KB_RIGHT);
				break;
			case KEY_F1:
				buff_add(KB_F1);
				break;
			case KEY_F2:
				buff_add(KB_F2);
				break;
			case KEY_F3:
				buff_add(KB_F3);
				break;
			case KEY_F4:
				buff_add(KB_F4);
				break;
			case KEY_F5:
				buff_add(KB_F5);
				break;
			case KEY_F6:
				buff_add(KB_F6);
				break;
			case KEY_F7:
				buff_add(KB_F7);
				break;
			case KEY_F8:
				buff_add(KB_F8);
				break;
			case KEY_F9:
				buff_add(KB_F9);
				break;
			case KEY_F10:
				buff_add(KB_F10);
				break;
			default:
				break;
			}
		}
	} else {		/* key released */
		switch (scancode) {
		case KEY_LSHIFT:
			buff_add(KB_LSHIFT_UP);
			break;
		case KEY_RSHIFT:
			buff_add(KB_RSHIFT_UP);
			break;
		case KEY_CONTROL:
			buff_add(KB_CTRL_UP);
			break;
		case KEY_ALT:
			buff_add(KB_ALT_UP);
			break;
		case KEY_UP:
			buff_add(KB_UP_UP);
			break;
		case KEY_DOWN:
			buff_add(KB_DOWN_UP);
			break;
		case KEY_LEFT:
			buff_add(KB_LEFT_UP);
			break;
		case KEY_RIGHT:
			buff_add(KB_RIGHT_UP);
			break;
		case KEY_F1:
			buff_add(KB_F1_UP);
			break;
		case KEY_F2:
			buff_add(KB_F2_UP);
			break;
		case KEY_F3:
			buff_add(KB_F3_UP);
			break;
		case KEY_F4:
			buff_add(KB_F4_UP);
			break;
		case KEY_F5:
			buff_add(KB_F5_UP);
			break;
		case KEY_F6:
			buff_add(KB_F6_UP);
			break;
		case KEY_F7:
			buff_add(KB_F7_UP);
			break;
		case KEY_F8:
			buff_add(KB_F8_UP);
			break;
		case KEY_F9:
			buff_add(KB_F9_UP);
			break;
		case KEY_F10:
			buff_add(KB_F10_UP);
			break;
		default:
			if (__jlib_ascii_tab[scancode]) {
				if (__jlib_caps_state) {
					buff_add(__jlib_caps_tab[scancode] | (1 << 15));
				} else {
					if ((__jlib_kb_state[KEY_LSHIFT]) || (__jlib_kb_state[KEY_RSHIFT])) {
						buff_add(__jlib_shift_tab[scancode] | (1 << 15));
					} else {
						buff_add(__jlib_ascii_tab[scancode] | (1 << 15));
					}
				}
			}
			break;
		}
	}
}