/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */

/* target specific includes for DJGPP_V2/ESA */

#ifndef __JTARGET_H__
#define __JTARGET_H__

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef DJGPP_V2
#error Wrong Target header file included in build.
#endif

#ifndef DJ_320x200x256
#ifndef DJ_640x480x256
#ifndef DJ_800x600x256
#error Wrong Target header file included in build.
#endif
#endif
#endif

#include <string.h>

/* Linear frame buffer stuff */
int _jlib_sel;        			/* frame buffer memory selector */

/* INPUT */
#define KEYBOARD_AVAILABLE 1    /* keyboard support is available */
#define MOUSE_AVAILABLE 1	/* mouse is available */ 
#define JOYSTICK_AVAILABLE 1    /* joystick support */

/* mouse */
#define MOUSE_NUM_BUTTONS 3
#define MOUSE_B_LEFT   1
#define MOUSE_B_MIDDLE 2
#define MOUSE_B_RIGHT  4

#define BUTTON_DOWN(status)    (status)
#define BUTTON_CHECK(status,x) (status & (x))

#define UCLOCK_TICKS_PER_SECOND 1000000L

/* joystick */
typedef struct  {
	int joy,xcen,ycen,x1,y1,x2,y2,deadx1,deady1,deadx2,deady2;
} logical_joy;

extern logical_joy	__jlib_joys[3];

#define JOY_FIRE1	1
#define JOY_FIRE2	2

#define FIRE_1_DOWN(status)	(status & JOY_FIRE1)
#define FIRE_2_DOWN(status)	(status & JOY_FIRE2)

/* SCREEN */
#ifdef DJ_320x200x256
#define  SCREEN_WIDTH	320
#define  SCREEN_HEIGHT	200
#define  SCREEN_MAX_X	319
#define  SCREEN_MAX_Y	199
#endif

#ifdef DJ_640x480x256
#define  SCREEN_WIDTH	640
#define  SCREEN_HEIGHT	480
#define  SCREEN_MAX_X	639
#define  SCREEN_MAX_Y	479
#endif

#ifdef DJ_800x600x256
#define  SCREEN_WIDTH	800
#define  SCREEN_HEIGHT	600
#define  SCREEN_MAX_X	799
#define  SCREEN_MAX_Y	599
#endif

#define  SCREEN_NUM_COLORS	256
#define  SCREEN_NUM_PAGES	1

extern int __jlib_pg;
extern int __jlib_mouse_visible;
extern int   __jlib_previous_mode;
extern int  __jlib_screen_initted;
extern int __jlib_is_13h;
extern int __jlib_is_linear;
extern int vesa_pages;
extern int vesa_width;
extern int vesa_gran1024;
extern int vesa_remains;
#define __setpg(bank) __asm__ __volatile__("movw $0x4f05, %%ax; xorw %%bx, %%bx; int $0x10": : "d" (bank): "ax", "bx", "dx")


/* MEMORY OPERATIONS */
#define get_best_copy_method(addr1,addr2,len) 1

#define ALIGNMENT_STATE_1   0
#define ALIGNMENT_STATE_2   1
#define ALIGNMENT_STATE_3   2
#define ALIGNMENT_STATE_4   3
#define ALIGNMENT_STATE_5   4
#define ALIGNMENT_STATE_6   5
#define ALIGNMENT_STATE_7   6
#define ALIGNMENT_STATE_8   7

/* some copies are optimised according to alignment */
/* every memory copy is done using memcpy */
#define MEM_COPY_ALIGN_1(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_2(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_3(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_4(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_5(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_6(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_7(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_8(x,y,z)	memcpy( (y) , (x) , (z) )

#define FAST_SHORT_COPY(s,d,len)	memcpy( (d) , (s) , (len) )
#define FAST_LONG_COPY(s,d,len)	memcpy( (d) , (s) , (len) )
#define FAST_VERY_LONG_COPY(s,d,len)	memcpy( (d) , (s) , (len) )
#define BYTE_COPY(s,d,len)       memcpy( (d) , (s) , (len) )
#define WORD_COPY(s,d,len)       memcpy( (d) , (s) , (len) )
#define LONG_COPY(s,d,len)       memcpy( (d) , (s) , (len) )

/* every memory store is done using memset */
#define MEM_STORE_ALIGN_1(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_2(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_3(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_4(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_5(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_6(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_7(d,val,len)  memset( (d) , (val) , (len) )
#define MEM_STORE_ALIGN_8(d,val,len)  memset( (d) , (val) , (len) )

#define FAST_SHORT_STORE(d,val,len)  memset( (d) , (val) , (len) )
#define FAST_LONG_STORE(d,val,len)   memset( (d) , (val) , (len) )
#define FAST_VERY_LONG_STORE(d,val,len) memset( (d) , (val) , (len) )
#define BYTE_STORE(d,val,len)        memset( (d) , (val) , (len) )
#define WORD_STORE(d,val,len)        memset( (d) , (val) , (len) )
#define LONG_STORE(d,val,len)        memset( (d) , (val) , (len) )


#ifdef __cplusplus
}
#endif 

#endif
