/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+ */
/*| Draw a non clipping filled triangle.                                   | */
/*+------------------------------------------------------------------------+ */
void buff_filled_triangleNC(buffer_rec * buff, int x1, int y1, int x2, int y2,
			  int x3, int y3, UBYTE col)
{
	int x[3], y[3];

	JLIB_ENTER("buff_filled_triangleNC");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif
	
	x[0]=x1;
	x[1]=x2;
	x[2]=x3;

	y[0]=y1;
	y[1]=y2;
	y[2]=y3;

	buff_convex_polyNC(buff, 3, x, y, col);

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*| Draw a clipping filled triangle.                                       | */
/*+------------------------------------------------------------------------+ */
void buff_filled_triangle(buffer_rec * buff, int x1, int y1, int x2, int y2,
			  int x3, int y3, UBYTE col)
{
	int x[3], y[3];

	JLIB_ENTER("buff_filled_triangle");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif
	
	x[0]=x1;
	x[1]=x2;
	x[2]=x3;

	y[0]=y1;
	y[1]=y2;
	y[2]=y3;

	buff_convex_poly(buff, 3, x, y, col);

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*| Draw a non-clipping triangle outline.                                  | */
/*+------------------------------------------------------------------------+ */
void buff_draw_triangleNC(buffer_rec * buff, int x1, int y1, int x2, int y2,
			  int x3, int y3, UBYTE col)
{
	JLIB_ENTER("buff_draw_triangleNC");

	buff_draw_lineNC(buff, x1, y1, x2, y2, col);
	buff_draw_lineNC(buff, x2, y2, x3, y3, col);
	buff_draw_lineNC(buff, x3, y3, x1, y1, col);

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*| Draw a clipping triangle outline.                                      | */
/*+------------------------------------------------------------------------+ */
void buff_draw_triangle(buffer_rec * buff, int x1, int y1, int x2, int y2,
			int x3, int y3, UBYTE col)
{

	JLIB_ENTER("buff_draw_triangle");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	buff_draw_line(buff, x1, y1, x2, y2, col);
	buff_draw_line(buff, x2, y2, x3, y3, col);
	buff_draw_line(buff, x3, y3, x1, y1, col);

	JLIB_LEAVE;
}