/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+ */
/*|Draw a rect with corners x1, y1 to x2 , y2 in color c without clipping  | */
/*+------------------------------------------------------------------------+ */
void buff_draw_rectNC(buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
	UBYTE *buffer;

	JLIB_ENTER("buff_draw_rectNC");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	if (x1 > x2)
		JLIB_SWAP(x1, x2);
	if (y1 > y2)
		JLIB_SWAP(y1, y2);

	buffer = B_OFFSET(buff, y1) + x1;

	x2 = x2 - x1 + 1;
	y2 = y2 - y1 + 1;

	if (x2 < 17)
		while (y2--) {
			MEM_STORE_SHORT(buffer, c, x2);
			buffer += B_X_SIZE(buff);
		}
	 else
		while (y2--) {
			MEM_STORE_LONG(buffer, c, x2);
			buffer += B_X_SIZE(buff);
		}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Draw a rect with corners x1, y1 to x2, y2 in color c with clipping      | */
/*+------------------------------------------------------------------------+ */
void buff_draw_rect(buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
	JLIB_ENTER("buff_draw_rect");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	/* Clip */
	if (x1 > x2)
		JLIB_SWAP(x1, x2);
	if (y1 > y2)
		JLIB_SWAP(y1, y2);

	if (x2 > B_CX2(buff))
		x2 = B_CX2(buff);
	 else
		if (x2 < B_CX1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y2 > B_CY2(buff))
		y2 = B_CY2(buff);
	 else
		if (y2 < B_CY1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (x1 < B_CX1(buff))
		x1 = B_CX1(buff);
	else
		if (x1 > B_CX2(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y1 < B_CY1(buff))
		y1 = B_CY1(buff);
	else
		if (y1 > B_CY2(buff)) {
			JLIB_LEAVE;
			return;
		}

	buff_draw_rectNC(buff, x1, y1, x2, y2, c);

	JLIB_LEAVE;
}