/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
/* inspiration for this code came from analygous routines in 'snippets' */

#include <conio.h>
#include <i86.h>

/* Constants */
#define TWO_BYTE_MODE_2  0x34	/* timer 0,2-byte read/write,mode 2, binary. */
#define TIMER_0_PORT  0x40	/* Timer 0 data port address. */
#define TIMER_MODE    0x43	/* Timer mode port address. */
#define BIOS_TICK_SEGMENT   0x40	/* BIOS data segment. */
#define BIOS_TICK_OFFSET    0x6c	/* Address of BIOS (18.2/s) tick count */
#define SCALE    10000		/* Scale factor for timer ticks. */

/* This assumes 18.2 BIOS ticks/sec from the 8253 clocked at 1.19 MHz. */
#define us_BTIK  54925		/* Micro sec per BIOS clock tick. */
#define f_BTIK    4595		/* Fractional part of usec per BIOS tick. */
#define us_TTIK   8381		/* Usec per timer tick * SCALE. (4/4.77 MHz) */

#pragma aux do_cli = "cli"
#pragma aux do_sti = "sti"

static __jlib_uclock_initted = 0;

void uclock_init(void)
{
	if (!__jlib_uclock_initted) {
		do_cli();

		outp(TIMER_MODE, TWO_BYTE_MODE_2);
		outp(TIMER_0_PORT, 0);	/* Initial count = 65636  */
		outp(TIMER_0_PORT, 0);

		do_sti();
		__jlib_uclock_initted = 1;
	}
}


unsigned int uclock_read(void)
{
	unsigned char msb, lsb;
	unsigned int tim_ticks, count;
	unsigned int far *x;

	if (!__jlib_uclock_initted) {
		return 0;
	}
	do_cli();

	outp(TIMER_MODE, 0);	/* Latch count.  */
	lsb = (unsigned char) inp(TIMER_0_PORT);	/* Read count.   */
	msb = (unsigned char) inp(TIMER_0_PORT);

	/* Get BIOS tick count */
	x = MK_FP(BIOS_TICK_SEGMENT, BIOS_TICK_OFFSET);
	count = (*x);

	do_sti();

	/* Merge PIT channel 0 count with BIOS tick count */
	tim_ticks = (unsigned) (-1) - ((msb << 8) | lsb);

	return ((count * us_BTIK) + ((int) tim_ticks * us_TTIK + (count * us_BTIK) % SCALE) / SCALE);
}
