/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>
#include <vga.h>
#include <vgamouse.h>


#define M_HEIGHT 16
#define M_WIDTH  10
#define X_LEFT   (xpos)
#define X_RIGHT  (xpos+M_WIDTH)
#define Y_TOP    (ypos)
#define Y_BOTTOM (ypos+M_HEIGHT)

extern vga_modeinfo *__jlib_modeinfo;
extern buffer_rec	__jlib_screen_buff;
static void getbox(int x, int y, int w, int h, UBYTE * bp);

static UBYTE __jlib_mouse_data[] =
{
	255, 255, 0, 0, 0, 0, 0, 0, 0, 0,
	255, 15, 255, 0, 0, 0, 0, 0, 0, 0,
	255, 15, 15, 255, 0, 0, 0, 0, 0, 0,
	255, 15, 15, 15, 255, 0, 0, 0, 0, 0,
	255, 15, 15, 15, 15, 255, 0, 0, 0, 0,
	255, 15, 15, 15, 15, 15, 255, 0, 0, 0,
	255, 15, 15, 15, 15, 15, 15, 255, 0, 0,
	255, 15, 15, 15, 15, 15, 15, 15, 255, 0,
	255, 15, 15, 15, 15, 15, 15, 15, 15, 255,
	255, 15, 15, 15, 15, 15, 255, 255, 255, 0,
	255, 15, 15, 255, 15, 15, 255, 0, 0, 0,
	255, 15, 255, 0, 255, 15, 15, 255, 0, 0,
	0, 255, 0, 0, 255, 15, 15, 255, 0, 0,
	0, 0, 0, 0, 0, 255, 15, 15, 255, 0,
	0, 0, 0, 0, 0, 255, 15, 15, 255, 0,
	0, 0, 0, 0, 0, 0, 255, 255, 0, 0,
};

static int __jlib_mouse_x;
static int __jlib_mouse_y;
static int __jlib_mouse_button;

buffer_rec *__jlib_mouse_sv;
buffer_rec *__jlib_mouse_blit;
buffer_rec *__jlib_mouse_ptr;

static UBYTE __jlib_mouse_showing;
static UBYTE __jlib_mouse_initted = 0;

void draw_mouse(void);
void save_mouse(void);
void restore_mouse(void);
void mouse_handle(int button, int dx, int dy);


/*+--------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                        | */
/*+--------------------------------------------------------------------------+ */
int mouse_present(void)
{
	JLIB_ENTER("mouse_present");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	__jlib_mouse_initted = mouse_init("/dev/mouse", MOUSE_MICROSOFT, MOUSE_DEFAULTSAMPLERATE);

	if (!__jlib_mouse_initted) {
		__jlib_mouse_initted = 1;
		mouse_setxrange(0, SCREEN_MAX_X);
		mouse_setyrange(0, SCREEN_MAX_Y);
		mouse_setwrap(MOUSE_NOWRAP);

		__jlib_mouse_x = 100;
		__jlib_mouse_y = 100;
		__jlib_mouse_showing = 0;	/* off */
		mouse_setposition(100, 100);

		mouse_seteventhandler(mouse_handle);

		__jlib_mouse_sv = buff_init(M_WIDTH, M_HEIGHT);
		__jlib_mouse_blit = buff_init(M_WIDTH, M_HEIGHT);
		__jlib_mouse_ptr = buff_init(M_WIDTH, M_HEIGHT);
		memcpy(B_BUFF_PTR(__jlib_mouse_ptr),__jlib_mouse_data,M_WIDTH * M_HEIGHT);

		mouse_show_pointer();

		JLIB_LEAVE;
		return MOUSE_PRESENT;
	}

	__jlib_mouse_initted = 0;

	JLIB_LEAVE;
	return MOUSE_ABSENT;
}


/*+--------------------------------------------------------------------------+ */
/*|show the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_show_pointer(void)
{
	JLIB_ENTER("mouse_show_pointer");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	if (!__jlib_mouse_initted) {
		JLIB_LEAVE;
		return;
	}

	mouse_update();

	if (!__jlib_mouse_showing) {
		__jlib_mouse_showing = 1;
		save_mouse();
		draw_mouse();
	}
	mouse_update();

	JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+ */
/*|hide the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_hide_pointer(void)
{
	JLIB_ENTER("mouse_hide_pointer");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	if (!__jlib_mouse_initted) {
		JLIB_LEAVE;
		return;
	}
	mouse_update();

	if (__jlib_mouse_showing != 0) {
		__jlib_mouse_showing = 0;
		restore_mouse();
	}

	JLIB_LEAVE;
}

/*+--------------------------------------------------------------------------+ */
/*|read pointer coordinates                                                  | */
/*+--------------------------------------------------------------------------+ */
void mouse_get_status(int *x_pos, int *y_pos, int *b_status)
{
	JLIB_ENTER("mouse_get_status");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	if (!__jlib_mouse_initted) {
		JLIB_LEAVE;
		return;
	}

	mouse_update();

	*x_pos = __jlib_mouse_x;
	*y_pos = __jlib_mouse_y;
	*b_status = __jlib_mouse_button;

	JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+ */
/*|change pointer coordinates.                                               | */
/*+--------------------------------------------------------------------------+ */
void mouse_set_status(int x, int y)
{
	JLIB_ENTER("mouse_set_status");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	if (!__jlib_mouse_initted) {
		JLIB_LEAVE;
		return;
	}
	if (__jlib_mouse_showing != 0) {
		restore_mouse();
		__jlib_mouse_x = x;
		__jlib_mouse_y = y;
		mouse_setposition(x, y);
		save_mouse();
		draw_mouse();
	}
	else {
		__jlib_mouse_x = x;
		__jlib_mouse_y = y;
		mouse_setposition(x, y);
	}

	mouse_update();
	JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+ */
/*|shut down the mouse.                                                      | */
/*+--------------------------------------------------------------------------+ */
void mouse_closedown(void)
{
	JLIB_ENTER("mouse_closedown");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted) {
		JLIB_LEAVE;
		return;
	}
#endif
	if (!__jlib_mouse_initted) {
		JLIB_LEAVE;
		return;
	}
	
	mouse_hide_pointer();
	mouse_close();

	__jlib_mouse_initted = 0;
	JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+ */
/*|mouse handler.                                                            | */
/*+--------------------------------------------------------------------------+ */
void mouse_handle(int button, int dx, int dy)
{
	if (__jlib_mouse_showing)
		restore_mouse();
	__jlib_mouse_button = button;

	/* update coords, ensuring they don't get off the screen */
	if ((__jlib_mouse_x + dx) > SCREEN_MAX_X)
		__jlib_mouse_x = SCREEN_MAX_X;
	else
		if ((__jlib_mouse_x + dx) < 0)
			__jlib_mouse_x = 0;
		else
			__jlib_mouse_x += dx;

	if ((__jlib_mouse_y + dy) > SCREEN_MAX_Y)
		__jlib_mouse_y = SCREEN_MAX_Y;
	else
		if ((__jlib_mouse_y + dy) < 0)
			__jlib_mouse_y = 0;
		else
			__jlib_mouse_y += dy;


	if (__jlib_mouse_showing) {
		save_mouse();
		draw_mouse();
	}
}


void draw_mouse(void)
{
	buff_stencil_buff_toNC(__jlib_mouse_blit, 0, 0, __jlib_mouse_ptr, 0, 0, M_WIDTH - 1, M_HEIGHT - 1);
	screen_blit_buff_to(__jlib_mouse_x, __jlib_mouse_y, __jlib_mouse_blit, 0, 0, M_WIDTH - 1, M_HEIGHT - 1);
}


void save_mouse(void)
{
	int xpos = __jlib_mouse_x;
	int ypos = __jlib_mouse_y;
	int endx, endy;

	if (X_RIGHT > SCREEN_MAX_X)
		endx = SCREEN_WIDTH;
	else
		endx = X_RIGHT;

	if (Y_BOTTOM > SCREEN_MAX_Y)
		endy = SCREEN_HEIGHT;
	else
		endy = Y_BOTTOM;

	if (__jlib_is_linear)
		buff_blit_buff_to(__jlib_mouse_sv, 0, 0, &__jlib_screen_buff, xpos, ypos, endx, endy);
	else
		getbox(xpos, ypos, endx - xpos, endy - ypos, B_BUFF_PTR(__jlib_mouse_sv));

	FAST_SHORT_COPY(B_BUFF_PTR(__jlib_mouse_sv), B_BUFF_PTR(__jlib_mouse_blit), M_WIDTH * M_HEIGHT);
}


void restore_mouse(void)
{
	screen_blit_buff_to(__jlib_mouse_x, __jlib_mouse_y, __jlib_mouse_sv, 0, 0, M_WIDTH - 1, M_HEIGHT - 1);
}


static void getbox(int x, int y, int w, int h, UBYTE * bp)
{
	int vp;
	int page;
	int i;
	vp = y * __jlib_modeinfo->linewidth + x;

	page = vp >> 16;
	vp &= 0xffff;
	vga_setpage(page);
	for (i = 0; i < h; i++) {
		if (vp + w > 0x10000)
			if (vp >= 0x10000) {
				page++;
				vga_setpage(page);
				vp &= 0xffff;
			}
			else {	/* page break within line */
				memcpy(bp, vga_getgraphmem() + vp, 0x10000 - vp);
				page++;
				vga_setpage(page);
				memcpy(bp + 0x10000 - vp, vga_getgraphmem(),
				       (vp + w) & 0xffff);
				vp = (vp + __jlib_modeinfo->linewidth) & 0xffff;
				bp += M_WIDTH;
				continue;
			}
		memcpy(bp, vga_getgraphmem() + vp, w);
		bp += M_WIDTH;
		vp += __jlib_modeinfo->linewidth;
	}
}