/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+ */
/*|Plot a point at (x, y) with color c with clipping                       | */
/*+------------------------------------------------------------------------+ */
JINLINE void buff_draw_point(buffer_rec * buff, int x, int y, UBYTE c)
{
	JLIB_ENTER("buff_draw_point");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	if ((x > B_CX2(buff)) || (y > B_CY2(buff)) || (x < B_CX1(buff)) || (y < B_CY1(buff))) {
		JLIB_LEAVE;
		return;
	}
	*(B_OFFSET(buff, y) + x) = c;

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Plot a point at (x, y) with color c without clipping                    | */
/*+------------------------------------------------------------------------+ */
JINLINE void buff_draw_pointNC(buffer_rec * buff, int x, int y, UBYTE c)
{
	JLIB_ENTER("buff_draw_pointNC");

	*(B_OFFSET(buff, y) + x) = c;

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Get a point at (x, y) with clipping                                     | */
/*+------------------------------------------------------------------------+ */
JINLINE UBYTE buff_get_point(buffer_rec * buff, int x, int y)
{
	JLIB_ENTER("buff_get_point");

	if ((x > B_CX2(buff)) || (y > B_CY2(buff)) || (x < B_CX1(buff)) || (y < B_CY1(buff))) {
		JLIB_LEAVE;
		return 0;
	}

	JLIB_LEAVE;
	return *(B_OFFSET(buff, y) + x);
}


/*+------------------------------------------------------------------------+ */
/*|Get a point at (x, y) without clipping                                  | */
/*+------------------------------------------------------------------------+ */
JINLINE UBYTE buff_get_pointNC(buffer_rec * buff, int x, int y)
{
	return *(B_OFFSET(buff, y) + x);
} 