/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <stdlib.h>
#include <jlib.h>

/* Automatically grabs sprites from a .pcx */

int is_top_corner(buffer_rec *buff,int i,int col);

void usage(void);

int main(int argc,char **argv)
{
	sprite_system *sys;
	image *pcx_pic;
	buffer_rec *offscreen;
	int i, frame=0;
	UBYTE border_col;
	char input;

	JLIB_DEBUG_OFF;

	if(argc!=3)
		usage();

	pcx_pic=image_load_pcx(argv[1]);
	if(pcx_pic == NULL)
		jlib_exit("PCX load failed.");

	sys=sprite_init(1,64);
	screen_set_video_mode();

	kb_init();
	screen_block_set_pal(IMG_PALETTE(pcx_pic));
	screen_put_pal(255,255,255,15);

	offscreen=buff_init(IMG_WIDTH(pcx_pic),IMG_HEIGHT(pcx_pic));

	buff_blit_img_to(offscreen,0,0,pcx_pic,0,0,IMG_MAX_X(pcx_pic),IMG_MAX_Y(pcx_pic));
	screen_blit_buff_to(0,0,offscreen,0,0,B_MAX_X(offscreen),B_MAX_Y(offscreen));

	border_col=pcx_pic->data[0]; /* set border color */

	/* loop through and build */
	for(i=IMG_WIDTH(pcx_pic);i<IMG_WIDTH(pcx_pic)*(IMG_HEIGHT(pcx_pic)-2);i++){
		if(is_top_corner(offscreen,i,border_col)){
			int x1,y1,x2,y2;

			x1=(i%IMG_WIDTH(pcx_pic));
			y1=(i/IMG_WIDTH(pcx_pic));
			x2=x1;y2=y1;

			do{
				x2++;
			} while(buff_get_point(offscreen,x2+1,y1)!=border_col);

			do{
				y2++;
			} while(buff_get_point(offscreen,x1,y2+1)!=border_col);

			/* outline the sprite */
			buff_draw_box(offscreen,x1-1,y1-1,x2+1,y2+1,15);
			screen_blit_buff_to(0,0,offscreen,0,0,B_MAX_X(offscreen),B_MAX_Y(offscreen));

			input = kb_get_next_key();

			if ((input=='Y')||(input=='y')) {
				/* build the sprite */
				if((x2-x1 >4) && (y2-y1 >4)) {
					sprite_build_from_buff(sys,frame,offscreen,x1,y1,x2,y2);
					frame++;
				}
			}
			/* re-outline the sprite to indicate finished this sprite */
			buff_draw_box(offscreen,x1-1,y1-1,x2+1,y2+1,border_col);
			screen_blit_buff_to(0,0,offscreen,0,0,B_MAX_X(offscreen),B_MAX_Y(offscreen));
		}
	}

	kb_closedown();

	if(SPR_NUM_LOADED(sys))
		sprite_save(argv[2],sys);
	screen_restore_video_mode();
	return(1);
}


/* is this the upper left corner of a sprite? */
int is_top_corner(buffer_rec *buff,int i,int col)
{
	if((buff->buffer[i]!=col) && (buff->buffer[i-1]==col) &&
		(buff->buffer[i-B_X_SIZE(buff)]==col) &&
		(buff->buffer[i-B_X_SIZE(buff)-1]==col) &&
		(buff->buffer[i-B_X_SIZE(buff)+1]==col) &&
		(buff->buffer[i+B_X_SIZE(buff)-1]==col))
		return 1;
	return 0;
}


/* display usage information */
void usage(void)
{
	puts("\nautograb.exe: Grab sprite from a PCX file automatically.");
	puts("Usage: autograb.exe <pcx_file> <output_file>");
	puts("The top left pixel (and anything not a sprite) must be the same color,");
	puts("which should not appear in any sprites.");
	puts("Press Y to save a highlited sprite.\n");
	exit(0);
}