/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * X Version Copyright (C) 1995 Mike Manley
 * Minor bugfixes/enhancements 1996 by Henrik Schmidt 
 * Small changes/bugfixes 1997 by Jon Griffiths
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>

/* some global stuff to help us manage */
Display *jxdisplay;
int	jxscreen;
Window	jxwindow;
Colormap	jxcolormap;
GC	jxgc;
long	jxmask;
char	version_string[] = "X11 API";
int	__jlib_screen_initted = 0;


/*+------------------------------------------------------------------------+ */
/*|set video mode.                                                         | */
/*+------------------------------------------------------------------------+ */
int screen_set_video_mode(void)
{
	/* Open X Display and create window */
	/* Note - this will currently only work on a 256 color depth 8 XServer */
	XEvent		event;
	XGCValues	gcvals;
        XSizeHints	sh;
	XSetWindowAttributes	winattr;
	unsigned long	gcvmask = 0;
	char		*nam[2];

	if (__jlib_screen_initted)
		return 1;

	if ((jxdisplay = XOpenDisplay(NULL)) == NULL)
		return 0;	/* mode set failed */

	/* Get the default screen */
	jxscreen = DefaultScreen(jxdisplay);

	/* Create a Graphics Context to use for blitting */
	gcvals.graphics_exposures = 0;
	gcvmask = GCGraphicsExposures;
	jxgc = XCreateGC(jxdisplay, RootWindow(jxdisplay, jxscreen), gcvmask, &gcvals);

	/* and try to create a screen sized (hopefully depth 8) window on it! */
/*	jxwindow = XCreateSimpleWindow(jxdisplay, RootWindow(jxdisplay, jxscreen),
			     0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0, 0);
*/
	winattr.backing_store = WhenMapped;
	winattr.save_under = True;
	winattr.border_pixel = 0;

	jxwindow = XCreateWindow(jxdisplay,RootWindow(jxdisplay, jxscreen),0, 0,SCREEN_WIDTH, SCREEN_HEIGHT,0,8,InputOutput,CopyFromParent,CWBorderPixel|CWBackingStore,&winattr);
 
	/* Now try to create a colormap */
	jxcolormap = XCreateColormap(jxdisplay, jxwindow, DefaultVisual(jxdisplay, jxscreen),AllocAll);

	/* Set the colormap to the window */
	XSetWindowColormap(jxdisplay, jxwindow, jxcolormap);
	
	/* Be friendly and tell the window manager we need a colormap */
	XSetWMColormapWindows(jxdisplay, jxwindow, NULL, 0);

	nam[0] = __jlib_app_title;
	nam[1] = NULL;

	sh.width = sh.min_width = sh.max_width = SCREEN_WIDTH;
	sh.height = sh.min_height = sh.max_height = SCREEN_HEIGHT;
	sh.flags |= (PSize|USSize|PMinSize|PMaxSize);
	
	XSetStandardProperties(jxdisplay,jxwindow,__jlib_app_title,__jlib_app_title,None,nam,1,&sh);

	/* Finally read the event queue - we need to do this 'coz X doesn't */
	/* display our window until we do. */
/*	while (XCheckMaskEvent(jxdisplay, ~NoEventMask, &event));
*/
	XSelectInput(jxdisplay,jxwindow,StructureNotifyMask|ExposureMask);
	event.type = 0;

	/* Map the window */
	XMapWindow(jxdisplay, jxwindow);

	/* Flush the display to ensure all requests are sent */
	XFlush(jxdisplay);

	do {
		XWindowEvent(jxdisplay, jxwindow, StructureNotifyMask, &event);
	} while (event.type != MapNotify);

	__jlib_screen_initted = 1;

	screen_clear();
/*	XClearWindow(jxdisplay,jxwindow);
	XFlush(jxdisplay);
*/

	XSelectInput(jxdisplay,jxwindow,NoEventMask);

	/* return success */
	return 1;
}


/*+------------------------------------------------------------------------+ */
/*|close the X window and return                                           | */
/*+------------------------------------------------------------------------+ */
void screen_restore_video_mode(void)
{
	if (__jlib_screen_initted) {
		/* Destroy our window and Close X */
		XDestroyWindow(jxdisplay, jxwindow);
		XFreeGC(jxdisplay, jxgc);
		XFreeColormap(jxdisplay, jxcolormap);
		XCloseDisplay(jxdisplay);
		__jlib_screen_initted = 0;
	}
}


/*+------------------------------------------------------------------------+ */
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */
int screen_get_page(void)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	return 1;
}


/*+------------------------------------------------------------------------+ */
/*|set the given  page number.                                             | */
/*+------------------------------------------------------------------------+ */
void screen_set_page(int page)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	/* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page.                                          | */
/*+------------------------------------------------------------------------+ */
void screen_show_page(int page)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	/* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Wait for the retrace beam to move offscreen.                            | */
/*+------------------------------------------------------------------------+ */
void screen_wait_vsync(void)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	/* not implememted yet */
}


/*+------------------------------------------------------------------------+ */
/*|Fill the screen with a given color.                                     | */
/*+------------------------------------------------------------------------+ */
void screen_fill(UBYTE color)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	XSetForeground(jxdisplay,jxgc,color);
	XFillRectangle(jxdisplay,jxwindow,jxgc,0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
}


/*+------------------------------------------------------------------------+ */
/*|Clear the screen.                                                       | */
/*+------------------------------------------------------------------------+ */
void screen_clear(void)
{
	screen_fill(0);
}


/*+------------------------------------------------------------------------+ */
/*|Return a buffer representing the screen if available.                   | */
/*+------------------------------------------------------------------------+ */
buffer_rec *screen_buff_init(void)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	return NULL; /* not implemented */
}


#ifndef __GNUC__		/* TO DO: implement for non gcc compilers */
void uclock_init(void)
{
}


unsigned int uclock_read(void)
{
	return 1;
}
#endif


/* We store X11's representation of a buffer in the buffer_rec structure */
void __target_buff_init(buffer_rec *buff)
{
	if (__jlib_screen_initted)
		buff->bimage = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8, ZPixmap, 0, B_BUFF_PTR(buff), B_X_SIZE(buff), B_Y_SIZE(buff), 8, B_X_SIZE(buff));
	else
		buff->bimage = NULL;
}


void __target_buff_free(buffer_rec *buff)
{
	if (buff->bimage != NULL) {
		XFree(buff->bimage);
		buff->bimage = NULL;
		B_BUFF_PTR(buff) = NULL;
	}
}