/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>
#include <stdio.h>

extern buffer_rec	__jlib_screen_buff;
extern int	__jlib_screen_initted;


/*+------------------------------------------------------------------------+ */
/*| Blit a fullscreen buffer to the screen                                 | */
/*+------------------------------------------------------------------------+ */
void screen_blit_fs_buffer(buffer_rec * buff)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
	jlib_check_buffer(buff);
#endif

	if (vesa_lfb || __jlib_is_13h) {
		UBYTE *out = B_BUFF_PTR(buff);
		UBYTE *scr = __jlib_screen_buff.buffer;
		FAST_LONG_COPY(out, scr, SCR_SIZE);
	}
	else {
		int i;
		UBYTE *out = B_BUFF_PTR(buff);

		for (i = 0; i < vesa_pages; i++) {
			__setpg(i);
			FAST_LONG_COPY((void *) out, (void *) VIDEO_START, vesa_gran1024);
			out += vesa_gran1024;
		}

		if (vesa_remains) {
			__setpg(vesa_pages);
			__jlib_pg = vesa_pages;
			FAST_LONG_COPY((void *) out, (void *) VIDEO_START, vesa_remains);
		}
		else
			__jlib_pg = vesa_pages -1;
	}
}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_toNC(int x, int y, buffer_rec * buff, int x1, int y1, int x2, int y2)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	if (vesa_lfb || __jlib_is_13h)
		buff_blit_buff_toNC(&__jlib_screen_buff, x, y, buff, x1, y1, x2, y2);
	else {
		int v_len = y2 - y1 + 1, h_len = x2 - x1 + 1;
		UBYTE *src = B_OFFSET(buff,y1) + x1;
		int offset, page;

		offset = y * vesa_width + x;
		if (offset == 0)
			page = 0;
		else {
			page = offset / vesa_gran1024;
			offset = offset % vesa_gran1024;
		}
		vesa_set_page(page);

		for (; v_len != 0; v_len--) {
			if (offset + h_len > vesa_gran1024)
				if (offset >= vesa_gran1024) {
					page++;
					__setpg(page);
					offset = offset % vesa_gran1024;
				}
				else {
					FAST_LONG_COPY(src, (void *) (VIDEO_START + offset), vesa_gran1024 - offset);
					page++;
					__setpg(page);
					FAST_LONG_COPY(src + vesa_gran1024 - offset,(void *) VIDEO_START,(offset + h_len) % vesa_gran1024);
					offset = (offset + vesa_width) % vesa_gran1024;
					src += B_X_SIZE(buff);
					continue;
				}
			FAST_LONG_COPY(src, (void *) (VIDEO_START + offset), h_len);
			src += B_X_SIZE(buff);
			offset = (int) offset + vesa_width;
		}
		__jlib_pg = page;
	}
}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_to(int x, int y, buffer_rec * buff, int x1, int y1, int x2, int y2)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
	jlib_check_buffer(buff);
#endif

	if (vesa_lfb || __jlib_is_13h)
		buff_blit_buff_to(&__jlib_screen_buff, x, y, buff, x1, y1, x2, y2);
	else {
		int v_len, h_len;
		UBYTE *src;
		int offset, page;
		int width, height;

		if (x1 > x2)
			JLIB_SWAP(x1, x2);
		if (y1 > y2)
			JLIB_SWAP(y1, y2);

		width = B_MAX_X(buff);
		height = B_MAX_Y(buff);

		/* clip src buffer */
		if ((x1 > width) || (y1 > height) || (x2 < 0) || (y2 < 0))
			return;

		if (x1 < 0)
			x1 = 0;
		if (y1 < 0)
			y1 = 0;

		if (x2 > width)
			x2 = width;
		if (y2 > height)
			y2 = height;

		/* clip to screen */
		if ((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y))
			return;

		if (x < 0) {
			x1 -= x;
			x = 0;
			if (x1 > x2)
				return;
		}

		if (y < 0) {
			y1 -= y;
			y = 0;
			if (y1 > y2)
				return;
		}

		v_len = y2 - y1 + 1;
		h_len = x2 - x1 + 1;

		if ((x + h_len) > SCREEN_WIDTH)
			h_len = SCREEN_WIDTH - x;
		if ((y + v_len) > SCREEN_HEIGHT)
			v_len = SCREEN_HEIGHT - y;

		width++;	/* from max x to buffer width */

		src = B_OFFSET(buff,y1) + x1;
		offset = y * vesa_width + x;

		if (offset == 0)
			page = 0;
		else {
			page = offset / vesa_gran1024;
			offset = offset % vesa_gran1024;
		}
		vesa_set_page(page * vesa_gran_mul);

		for (; v_len != 0; v_len--) {
			if (offset + h_len > vesa_gran1024)
				if (offset >= vesa_gran1024) {
					page++;
					__setpg(page);
					offset = offset % vesa_gran1024;
				}
				else {
					FAST_LONG_COPY((void *) src, (void *) (VIDEO_START + offset), vesa_gran1024 - offset);
					page++;
					__setpg(page);
					FAST_LONG_COPY(src + vesa_gran1024 - offset, (void *) VIDEO_START,(offset + h_len) % vesa_gran1024);
					offset = (offset + vesa_width) % vesa_gran1024;
					src += width;
					continue;
				}
			FAST_LONG_COPY(src, (void *) (VIDEO_START + offset), h_len);
			src += width;
			offset = (int) offset + vesa_width;
		}
		__jlib_pg = page;
	}
}
