/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>
#include <vga.h>


/*+------------------------------------------------------------------------+ */
/*|Set a color on screen                                                   | */
/*+------------------------------------------------------------------------+ */
JINLINE void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	vga_setpalette(col, red >> 2, green >> 2, blue >> 2);
}


/*+------------------------------------------------------------------------+ */
/*|Set all the colors from the given palette.                              | */
/*+------------------------------------------------------------------------+ */
void screen_block_set_pal(UBYTE * pal)
{
	int i;

	JLIB_ENTER("screen_block_set_pal");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
	jlib_check_palette(pal);
#endif

	for (i = 0; i < SCREEN_NUM_COLORS; i++) {
		vga_setpalette(i, pal[0] >> 2, pal[1] >> 2, pal[2] >> 2);
		pal += 3;
	}

	JLIB_LEAVE;
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
}