/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <pc.h>
#include <jlib.h>

/*+------------------------------------------------------------------------+ */
/*|Set a color on screen.                                                  | */
/*+------------------------------------------------------------------------+ */
JINLINE void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
	UBYTE a;

	JLIB_ENTER("screen_put_pal");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	outportb(0x3c8, col);
	a = inportb(0x80);
	outportb(0x3c9, red >> 2);
	a = inportb(0x80);
	outportb(0x3c9, green >> 2);
	a = inportb(0x80);
	outportb(0x3c9, blue >> 2);

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Set all the colors from the given palette.                              | */
/*+------------------------------------------------------------------------+ */
void screen_block_set_pal(UBYTE * pal)
{
	int i;

	JLIB_ENTER("screen_block_set_pal");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
	jlib_check_palette(pal);
#endif

	outportb(0x3c8, 0);
	inportb(0x80);

	for (i = 0; i < SCREEN_NUM_COLORS; i++) {
		outportb(0x3c9, pal[0] >> 2);
		outportb(0x3c9, pal[1] >> 2);
		outportb(0x3c9, pal[2] >> 2);
		pal += 3;
	}

	JLIB_LEAVE;
}