/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * By Lennart Steinke and Jon Griffiths
 */
#include <dos.h>
#include <go32.h>
#include <dpmi.h>
#include <string.h>
#include <stdlib.h>
#include <sys/movedata.h>
#include <sys/farptr.h>
#include <jlib.h>

#define PACKED	__attribute__ ((packed))

typedef struct {
	char signature[4]		PACKED;
	USHORT version		PACKED;
	ULONG oem_name		PACKED;
	ULONG capabilities	PACKED;
	USHORT video_modes_off	PACKED;
	USHORT video_modes_seg	PACKED;
	USHORT total_mem		PACKED;
	USHORT oem_rev		PACKED;
	ULONG oem_vendor		PACKED;
	ULONG oem_product		PACKED;
	ULONG oem_prod_rev	PACKED;
	UBYTE reserved[222]	PACKED;
	UBYTE oem_data[256]	PACKED;
} vesainfo;

typedef struct {
	USHORT attributes	PACKED;
	UBYTE Aattributes	PACKED;
	UBYTE Battributes	PACKED;
	USHORT granularity	PACKED;
	USHORT size		PACKED;
	USHORT segA		PACKED;
	USHORT segB		PACKED;
	UBYTE foobar[4]	PACKED;
	USHORT scan_bytes	PACKED;
	USHORT pix_width	PACKED;
	USHORT pix_height	PACKED;
	UBYTE cpix_width	PACKED;
	UBYTE cpix_height	PACKED;
	UBYTE mem_planes	PACKED;
	UBYTE bpp		PACKED;
	UBYTE num_banks	PACKED;
	UBYTE mem_model	PACKED;
	UBYTE bank_size	PACKED;
	UBYTE image_pages	PACKED;
	UBYTE res1		PACKED;
	UBYTE rmask		PACKED;
	UBYTE rfp		PACKED;
	UBYTE gmask		PACKED;
	UBYTE gfp		PACKED;
	UBYTE bmask		PACKED;
	UBYTE bfp		PACKED;
	UBYTE res_mask	PACKED;
	UBYTE res_fp	PACKED;
	UBYTE direct_col	PACKED;
	ULONG phys_ptr	PACKED;
	ULONG offscr_ptr	PACKED;
	short offscr_size	PACKED;
	UBYTE res2[206]	PACKED;
} vesamodedata;

#define PACKED_MEM	4
#define LINEAR_MODE	0x0080
#define AVAIL_MODE	0x0001
#define USE_LINEAR	0x4000
#define VBE2_SIG	(((int)'2'<<24)|((int)'E'<<16)|((int)'B'<<8)|'V')
#define VBE2_CONF	(((int)'A'<<24)|((int)'S'<<16)|((int)'E'<<8)|'V')
#define VESA_MAX_MODES	50

int	vesa_remains;
int	vesa_granularity;
int	vesa_gran_mul;
int	vesa_gran1024;
int	vesa_pages;
int	vesa_width;
int	__jlib_pg = 0;
int	__jlib_mouse_visible = 0;
int	__jlib_previous_mode = 0x3;
int	__jlib_screen_initted = 0;
int	__jlib_is_13h = 0;
int	__jlib_is_linear = 0;
char	version_string[] = "DJGPP VESA";
int	*vesa_modes;

unsigned int address;

/*+------------------------------------------------------------------------+ */ 
/*|Set the video mode.                                                     | */ 
/*+------------------------------------------------------------------------+ */ 
int screen_set_video_mode(void) 
{
	__dpmi_regs		regs;
	__dpmi_meminfo	mem_info;
	vesainfo		vesa_info;
	vesamodedata	vesa_mode_data;

	JLIB_ENTER("screen_set_video_mode");

	if(__jlib_screen_initted) {
		JLIB_LEAVE;
		return 1;
	}

	if (sizeof(vesa_info) > _go32_info_block.size_of_transfer_buffer){
		JLIB_PRINT_DEBUG_INFO("Transfer buffer too small");
		JLIB_LEAVE;
		return 0;
	}
	if (sizeof(vesa_mode_data) > _go32_info_block.size_of_transfer_buffer){
		JLIB_PRINT_DEBUG_INFO("Transfer buffer too small");
		JLIB_LEAVE;
		return 0;
	}

	JLIB_SIGNAL_SETUP;

	/* save previous mode */
	regs.h.ah = 0x0f;
	__dpmi_int(0x10, &regs);
	__jlib_previous_mode = regs.h.al;

	/* Check for VBE 2.0 */
	*(int *)&vesa_info.signature = VBE2_SIG;
	regs.x.ax= 0x4f00;
	regs.x.di= __tb & 0x0f;
	regs.x.es= (__tb >> 4) & 0xffff;
	dosmemput(&vesa_info, sizeof(vesa_info), __tb);
	__dpmi_int(0x10, &regs);
	dosmemget(__tb, sizeof(vesa_info), &vesa_info);

#if SCREEN_WIDTH != 320
	if (regs.x.ax != 0x004f) {
		JLIB_PRINT_DEBUG_INFO("No VESA support present.");
		JLIB_LEAVE;
		return 0;
	}
#endif

	if ((regs.x.ax == 0x004f) & (vesa_info.version >= 0x200) & (*(int *) vesa_info.signature == VBE2_CONF)) {
		int *dest, mode;
		unsigned long avail;

		JLIB_PRINT_DEBUG_INFO("Found VESA 2.0 interface...");

		/* Check if requested mode is supported */
		vesa_modes = (int *) malloc(VESA_MAX_MODES * sizeof(int));

		if (vesa_modes == NULL)
			jlib_exit(jlib_msg(JLIB_ENULL));

		dest = vesa_modes;
		avail = vesa_info.video_modes_off + vesa_info.video_modes_seg * 16;

		 _farsetsel(_dos_ds);

		/* copy available modes */
		while ((mode = _farnspeekw(avail)) != 0xffff) {
			*dest++ = mode;
			avail += 2;
		}
		*dest = -1;

		/* Traverse the list until we find a suitable mode */
		dest = vesa_modes;

		while (*dest != -1) {
			regs.x.ax = 0x4f01;
			regs.x.cx = *dest;
			regs.x.di = __tb & 0x0f;
			regs.x.es = (__tb >> 4) & 0xffff;
			__dpmi_int(0x10, &regs);

			dosmemget(__tb, sizeof(vesa_mode_data), &vesa_mode_data);

			if ((regs.x.ax == 0x004f) &&
				(vesa_mode_data.pix_width == SCREEN_WIDTH) &&
				(vesa_mode_data.pix_height == SCREEN_HEIGHT) &&
				(vesa_mode_data.attributes & LINEAR_MODE) &&
				(vesa_mode_data.mem_model == PACKED_MEM) &&
				(vesa_mode_data.bpp == 8) &&
				(vesa_mode_data.mem_planes == 1)) {

				mem_info.size = (ULONG) (vesa_mode_data.pix_width * vesa_mode_data.pix_height);
				mem_info.address = vesa_mode_data.phys_ptr;

				if (__dpmi_physical_address_mapping(&mem_info) != -1) {

					address = mem_info.address;

					/* Everything seems to be ok, so let's set the video mode */
					regs.x.ax = 0x4f02;
	     		 	      regs.x.bx = (*dest) | USE_LINEAR;

					__dpmi_int(0x10, &regs);

					if (regs.h.al == 0x4f && !regs.h.ah) {
						_jlib_sel = __dpmi_allocate_ldt_descriptors(1);
/*						__dpmi_lock_linear_region(&mem_info); */
						__dpmi_set_segment_base_address(_jlib_sel, address);
						__dpmi_set_segment_limit(_jlib_sel, (SCREEN_WIDTH * SCREEN_HEIGHT) | 0xfff);

						/* Set logical scan line width */
						regs.x.ax = 0x4f06;
						regs.h.bl = 0x00;
						regs.x.cx = SCREEN_WIDTH;
						__dpmi_int(0x10, &regs);

						/* Set address of upper left corner */
						regs.x.ax = 0x4f07;
						regs.x.bx = regs.x.cx = regs.x.dx = 0x0000;
						__dpmi_int(0x10, &regs);

						__jlib_is_linear = __jlib_screen_initted = 1;

						JLIB_PRINT_DEBUG_INFO("Set Linear mode OK");
						JLIB_LEAVE;
						return 1;
					}
				}
			}
			dest++;
		}
		JLIB_PRINT_DEBUG_INFO("Set Linear mode failed");
	}

	_jlib_sel = _dos_ds;

#if SCREEN_WIDTH == 320
	JLIB_PRINT_DEBUG_INFO("Using Mode 13h...");

	regs.x.ax = 0x13;
	__dpmi_int(0x10,&regs); /* set mode 13h */

	__jlib_is_13h = __jlib_screen_initted = 1;

	JLIB_LEAVE;
	return 1;
#else
	JLIB_PRINT_DEBUG_INFO("Trying VESA v1.2 interface...");

	/* Get v1.2 mode info */
	regs.x.ax = 0x4f01;
	regs.x.cx = VESA_MODE;
	regs.x.di = __tb & 0x0f;
	regs.x.es = (__tb >> 4) & 0xffff;
	__dpmi_int(0x10, &regs);
	dosmemget(__tb, sizeof(vesa_mode_data), &vesa_mode_data);

	if (regs.x.ax == 0x004f) {
		vesa_granularity = vesa_mode_data.granularity;
		vesa_width = vesa_mode_data.pix_width;
		if (vesa_width == 0)
			vesa_width = vesa_mode_data.scan_bytes;
		vesa_gran_mul = 64 / vesa_granularity;
		vesa_gran1024 = vesa_granularity * 1024;
		vesa_pages = SCR_SIZE / (vesa_gran1024);
		vesa_remains = SCR_SIZE - (vesa_pages * vesa_gran1024);

		/* Set the mode */
		regs.x.ax = 0x4f02;
		regs.x.bx = VESA_MODE;
		__dpmi_int(0x10, &regs);

		if (regs.h.al == 0x4f && regs.h.ah == 0) {
			__jlib_screen_initted = 1;
			JLIB_LEAVE;
			return 1;		/* mode set OK */
		}
	}

	screen_restore_video_mode();

	JLIB_LEAVE;
	return 0;				/* mode set failed */
#endif
}


/*+------------------------------------------------------------------------+ */ 
/*|Restore the video mode.                                                 | */
/*+------------------------------------------------------------------------+ */ 
void screen_restore_video_mode(void) 
{
	__dpmi_regs regs;

	JLIB_ENTER("screen_restore_video_mode");

	if(!__jlib_screen_initted) {
		JLIB_LEAVE;
		return;
	}

	regs.x.ax = __jlib_previous_mode;
	__dpmi_int(0x10,&regs);

	__jlib_screen_initted=0;
	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */ 
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */ 
int screen_get_page(void) 
{
	JLIB_ENTER("screen_get_page");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	JLIB_LEAVE;
      return 1;
}


/*+------------------------------------------------------------------------+ */ 
/*|Show the current drawing page.                                          | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_show_page (int page) 
{
	JLIB_ENTER("screen_show_page");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */ 
/*|Set drawing output to a page.                                           | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_set_page(int page)
{
	JLIB_ENTER("screen_set_page");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill (UBYTE color) 
{
	int col = (color << 24) | (color << 16) | (color << 8) | color;
	unsigned long addr;

	JLIB_ENTER("screen_fill");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	if ((__jlib_is_linear) || (__jlib_is_13h)) {
		int len = SCR_SIZE >> 2;

		if (__jlib_is_linear)
			addr = 0;
		else
			addr = 0xA0000;

		_farsetsel(_jlib_sel);

		while (len--) {
			_farnspokel(addr,col);
			addr += 4;
		}

		JLIB_LEAVE;
		return;
	}
	else {
		int i, len;

		for (i = 0; i < vesa_pages; i++) {
			len = vesa_gran1024 >> 2;
			addr = 0xA0000;
			__setpg(i);

			_farsetsel(_jlib_sel);
			while (len--) {
				_farnspokel(addr,col);
				addr+=4;
			}
		}

		if (vesa_remains) {
			len = vesa_remains >> 2;
			__setpg(vesa_pages);
			addr = 0xA0000;

			_farsetsel(_jlib_sel);
			while (len--) {
				_farnspokel(addr,col);
				addr+=4;
			}
			__jlib_pg = vesa_pages;
		}
		else
			__jlib_pg = vesa_pages - 1;
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear (void) 
{
	JLIB_ENTER("screen_clear");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	screen_fill(0); 

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Return a buffer representing the screen if available.                   | */
/*+------------------------------------------------------------------------+ */
buffer_rec *screen_buff_init(void)
{
	JLIB_ENTER("screen_buff_init");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	JLIB_LEAVE;
	return NULL;
}


/*+------------------------------------------------------------------------+ */ 
/*|Wait for the retrace beam to move offscreen.                            | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_wait_vsync(void)
{
	JLIB_ENTER("screen_wait_vsync");

#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif

	while((inportb(0x3da)&8) != 0);
	while((inportb(0x3da)&8) == 0);

	JLIB_LEAVE;
}