/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <jlib.h>


char version_string[] = "BORLAND C++ mode 13h";
static UBYTE __jlib_screen_initted=0;

/*+------------------------------------------------------------------------+ */ 
/*|Set the video mode.                                                     | */ 
/*+------------------------------------------------------------------------+ */ 
int screen_set_video_mode(void)
{
	if(!__jlib_screen_initted){
		asm {
			mov ax,0x13
			int 10h
		}
		__jlib_screen_initted=1;

		return 1;
	}
	return 0;
}


/*+------------------------------------------------------------------------+ */ 
/*|Restore the video mode.                                                 | */
/*+------------------------------------------------------------------------+ */ 
void screen_restore_video_mode(void)
{
	if(__jlib_screen_initted){
		asm {
			mov ax,0x3
			int 10h
		}
		__jlib_screen_initted=0;
	}
}


/*+------------------------------------------------------------------------+ */
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */
int screen_get_page (void)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	return 1;
}


/*+------------------------------------------------------------------------+ */
/*|set the given  page number.                                             | */
/*+------------------------------------------------------------------------+ */
void screen_set_page (int page)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	/* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page.                                          | */
/*+------------------------------------------------------------------------+ */
void screen_show_page (int page)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	/* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Wait for the retrace beam to move offscreen.                            | */ 
/*+------------------------------------------------------------------------+ */ 
screen_wait_vsync(void)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	while((inp(0x3da)&8) !=0);
	while((inp(0x3da)&8) ==0);
}

/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill(UBYTE color)
{
	memset(__VIDEO_START,color,64000);
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear(void)
{
	screen_fill(0);
}

/*+------------------------------------------------------------------------+ */
/*|Return a buffer representing the screen if available.                   | */
/*+------------------------------------------------------------------------+ */
buffer_rec *screen_buff_init(void)
{
#ifndef JLIB_PRODUCTION
	if (!__jlib_screen_initted)
		jlib_exit(jlib_msg(JLIB_EINIT));
#endif
	return NULL; /* not implemented */
}
