/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>
#include <stdio.h>
#include <dos.h>
#include <ctype.h>

#define FOR_BORLAND 1
#include "..\comm\comm_key.c"

void interrupt __jlib_keyint();
void interrupt (*oldkeyhandler)();


/*+------------------------------------------------------------------------+ */
/*| Initialise the keyboard.                                               | */
/*+------------------------------------------------------------------------+ */
void kb_init(void)
{
	if (__jlib_kb_initted)
		return;
 
	__jlib_kb_initted = 1;

	oldkeyhandler = _dos_getvect(9);
	_dos_setvect(9,__jlib_keyint);
}


/*+------------------------------------------------------------------------+ */
/*| Shut down the keyboard.                                                | */
/*+------------------------------------------------------------------------+ */
void kb_closedown(void)
{
	if (!__jlib_kb_initted)
		return;
 
	__jlib_kb_initted= 0;

	_dos_setvect(9, oldkeyhandler); 
} 

