/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>

/* TO DO: Optimise for correct endian machines */


/*+------------------------------------------------------------------------+ */
/*| Write an elementary type (int,short,char) where size <= 4              | */
/*+------------------------------------------------------------------------+ */
int jio_write_elementary_type(FILE * fp, void *type, size_t size)
{
	JLIB_ENTER("jio_write_elementary_type");

#ifndef JLIB_PRODUCTION
	if ((fp == NULL) || (type == NULL))
		jlib_exit(jlib_msg(JLIB_ENULL));
#endif

	switch (size) {
		case 1:{
			UBYTE c = *(UBYTE *) type;

			fputc(c, fp);
			break;
		}

		case 2:{
			USHORT c = *((USHORT *) type);

			fputc((UBYTE) (c & 0xff), fp);
			fputc((UBYTE) ((c >> 8) & 0xff), fp);
			break;
		}

		case 4:{
			ULONG c = *((ULONG *) type);

			fputc((UBYTE) (c & 0xff), fp);
			fputc((UBYTE) ((c >> 8) & 0xff), fp);
			fputc((UBYTE) ((c >> 16) & 0xff), fp);
			fputc((UBYTE) ((c >> 24) & 0xff), fp);
			break;
		}
#ifndef JLIB_PRODUCTION
	default:
		jlib_exit(jlib_msg(JLIB_EFILE));
#endif
	}

#ifndef JLIB_PRODUCTION
	if (ferror(fp))
		jlib_exit(jlib_msg(JLIB_EFILE));
#endif

	JLIB_LEAVE;
	return 1;
}



/*+------------------------------------------------------------------------+ */
/*| Read an elementary type (int,short,char) where size <= 4               | */
/*+------------------------------------------------------------------------+ */
int jio_read_elementary_type(FILE * fp, void *type, size_t size)
{
	int i;

	JLIB_ENTER("jio_read_elementary_type");

#ifndef JLIB_PRODUCTION
	if ((fp == NULL) || (type == NULL))
		jlib_exit(jlib_msg(JLIB_ENULL));
#endif

	switch (size) {
		case 1:{
			i = fgetc(fp);

			*(UBYTE *) type = (UBYTE) (i & 0xff);
			break;
		}

		case 2:{
			i = fgetc(fp);
			i |= (fgetc(fp) << 8);

			*((USHORT *) type) = (USHORT) (i & 0xffff);
			break;
		}

		case 4:{
			i = fgetc(fp);
			i |= (fgetc(fp) << 8);
			i |= (fgetc(fp) << 16);
			i |= (fgetc(fp) << 24);

			*((ULONG *) type) = (ULONG) i;
			break;
		}

#ifndef JLIB_PRODUCTION
	default:
		jlib_exit(jlib_msg(JLIB_EFILE));
#endif
	}

#ifndef JLIB_PRODUCTION
	if (ferror(fp))
		jlib_exit(jlib_msg(JLIB_EFILE));
#endif

	JLIB_LEAVE;
	return 1;
}