/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>
#include "rle.h"

/* The alogrithm used is:
 *   X is the next byte in the buffer:
 *     if X > 0 copy the next X bytes to the buffer.
 *     if X < 0 repeat the next byte -X times to the buffer.
 *     if X = 0 the end of the buffer has been reached.
 *   Keep going until we reach the end of the buffer.
 */


/*+------------------------------------------------------------------------+ */
/*| rle_encode - encode a rle buffer into another buffer                   | */
/*+------------------------------------------------------------------------+ */
long rle_encode(UBYTE * src, long len, UBYTE ** dest)
{
	long index, end_len;
	UBYTE value;
	char count;
	char *dst;

	JLIB_ENTER("rle_encode");

	/* do it once to see how big the dest buff must be */
	index = 0;
	value = src[index];
	index++;
	end_len = 0;

	while (index < len) {

		if (src[index] == value) {
			/* repeat */
			count = 2;

			index++;

			while ((index < len) && (src[index] == value) && (count < 127)) {
				count++;
				index++;
			};

			end_len += 2;

			value = src[index];

			if (index < len)
				index++;
		}
		else {
			/* store until repeat */
			count = 1;
			end_len += 2;	/* 1 for represt,  1 for 1st value */

			while ((index < len) && (src[index] != src[index + 1]) && (count < 127)) {
				end_len++;
				count++;
				index++;
			}

			value = src[index];
			if (index < len)
				index++;
		}
	}

	end_len++;		/* for zero at end */

	/* create space for the encoded buffer */
	if ((*dest = (UBYTE *) malloc(end_len)) == NULL)
		jlib_exit(jlib_msg(JLIB_EMALLOC));

	dst = (char *) (*dest);


	/* now do it for real into the destination buffer */
	index = 0;
	value = src[index];
	index++;

	while (index < len) {

		if (src[index] == value) {
			/* repeat */
			count = 2;

			index++;

			while ((index < len) && (src[index] == value) && (count < 127)) {
				count++;
				index++;
			}

			*dst = (char) -count;
			dst++;
			*dst = value;
			dst++;

			value = src[index];

			if (index < len)
				index++;
		}
		else {
			/* store until repeat */
			*dst = 0;	/* store temp val */
			dst++;

			count = 1;
			*dst = value;
			dst++;

			while ((index < len) && (src[index] != src[index + 1]) && (count < 127)) {
				*dst = src[index];
				dst++;
				count++;
				index++;
			}

			*(dst - count - 1) = count;
			value = src[index];

			if (index < len)
				index++;
		}
	}

	*dst = 0;		/* end of run */

	JLIB_LEAVE;
	return end_len;
}


/*+------------------------------------------------------------------------+ */
/*| rle_decode - decode a rle buffer into another buffer                   | */
/*+------------------------------------------------------------------------+ */
long rle_decode(UBYTE * src, UBYTE ** dest)
{
	long index, end_len;
	signed char value, *csrc = (signed char *) src;
	char *dst;

	JLIB_ENTER("rle_decode");

	/* do it once to see how much space we need */
	index = 0;
	value = csrc[index];
	end_len = 0;

	while (value != 0) {

		if (value < 0) {
			/* repeat next byte -value times */
			index++;

			for (; value != 0; value++)
				end_len++;

			index++;
			value = csrc[index];
		}
		else {
			/* copy the next value bytes to dst */
			for (; value != 0; value--) {
				index++;
				end_len++;
			}

			index++;
			value = csrc[index];
		}
	}

#ifdef DEBUG_JLB
	printf("end_len = %d \n", end_len);
#endif

	/* create space for the encoded buffer */
	if ((*dest = (UBYTE *) malloc(end_len)) == NULL)
		jlib_exit(jlib_msg(JLIB_EMALLOC));

	dst = (char *) (*dest);


	/* now do it for real into the destination buffer */
	index = 0;
	value = csrc[index];

	while (value != 0) {

#ifdef DEBUG_JLB
		printf("value=%d\n", value);
#endif

		if (value < 0) {
			/* repeat next byte -value times */
			index++;

			for (; value != 0; value++) {
				*dst = src[index];
				dst++;
			}

			index++;
			value = csrc[index];
		}
		else {
			/* copy the next value bytes to dst */
			for (; value != 0; value--) {
				index++;
				*dst = src[index];
				dst++;
			}

			index++;
			value = csrc[index];
		}
	}

	JLIB_LEAVE;
	return end_len;
}

/*+------------------------------------------------------------------------+ */
/*| Decode a rle buffer into a preallocated buffer                         | */
/*+------------------------------------------------------------------------+ */
void rle_decode_prealloc(UBYTE * src, UBYTE *dst)
{
	long index;
	signed char value, *csrc = (signed char *) src;

	JLIB_ENTER("rle_decode_prealloc");

	index = 0;
	value = csrc[index];

	while (value != 0) {

#ifdef DEBUG_JLB
		printf("value=%d\n", value);
#endif

		if (value < 0) {
			/* repeat next byte -value times */
			index++;

			for (; value != 0; value++) {
				*dst = src[index];
				dst++;
			}

			index++;
			value = csrc[index];
		}
		else {
			/* copy the next value bytes to dst */
			for (; value != 0; value--) {
				index++;
				*dst = src[index];
				dst++;
			}

			index++;
			value = csrc[index];
		}
	}

	JLIB_LEAVE;
}