

/* lz.c - See the accompianing header file "lz.h" for information 
   ** regarding copyright,  etc.
 */

#include <jlib.h>
#include "lz.h"

#define GET_32(x,c) x=c[0]+(c[1]*256)+(c[2]*256*256)+(c[3]*256*256*256)
/* unsigned long k = *(unsigned long *) (s =p_src); */

/* Input  : Specify input block using p_src_first and src_len.          */
/* Input  : Point p_dst_first to the start of the output zone (OZ).     */
/* Input  : Point p_dst_len to a ULONG to receive the output length.    */
/* Input  : Input block and output zone must not overlap.               */
/* Output : Length of output block written to *p_dst_len.               */
/* Output : Output block in Mem[p_dst_first..p_dst_first+*p_dst_len-1]. */
/* Output : May write in OZ=Mem[p_dst_first..p_dst_first+src_len+256-1]. */
/* Output : Upon completion guaranteed *p_dst_len<=src_len+FLAG_BYTES.  */
/* LZRW1 compression routine: */

void lz_compress(UBYTE * p_src_first, long src_len, UBYTE * p_dst_first, long *p_dst_len)
{
	UBYTE *p_src = p_src_first, *p_dst = p_dst_first;
	UBYTE *p_src_post = p_src_first + src_len, *p_dst_post = p_dst_first + src_len;
	UBYTE *p_src_max1 = p_src_post - 16, *p_src_max16 = p_src_post - 16 * 16;
	UBYTE *p_control;
	ULONG control = 0, control_bits = 0;
	static UBYTE *tree[(4096 * 2)];
	int lastnode;		/* radix search tree */

	JLIB_ENTER("lz_compress");

	for (lastnode = 0; lastnode < 4096; lastnode++) {
		tree[lastnode] = 0;
	}
	lastnode -= (4096 * 2);


	*p_dst = 0;
	p_dst += 4;
	p_control = p_dst;
	p_dst += 2;
	/* The Main Loop: */
	while (1) {
		unsigned int unroll = 16, len;
		unsigned long offset;

		if (p_dst > p_dst_post)
			goto overrun;
		if (p_src > p_src_max16) {
			unroll = 1;
			if (p_src > p_src_max1) {
				if (p_src == p_src_post)
					break;
				goto literal;
			}
		}
		/* Begin Unrolled Loop: */
		do {
			UBYTE *p, *q, *s;
			ULONG k;

			s = p_src;
			GET_32(k, s);	/* unsigned long k = *(unsigned long *) (s = p_src); */

			q = (UBYTE *) ((k & 0x0F0F) + ((k >> 12) & 0x0F0) - (4096 * 2));
			p = tree[(4096 * 2) + (int) q];
			k >>= 4;	/* scan bits 0..3|8..11|16..19 */

			if ((int) p >= 0)
				goto chk_offset_0;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_0;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_0;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_0;
			q = p + (k & 1);
			k >>= 1 + 4;
			p = tree[(4096 * 2) + (int) q];;	/* scan bits 4..7 */
			if ((int) p >= 0)
				goto chk_offset_1;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_1;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_1;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_1;
			q = p + (k & 1);
			k >>= 1 + 4;
			p = tree[(4096 * 2) + (int) q];;	/* scan bits 12..15 */
			if ((int) p >= 0)
				goto chk_offset_2;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_2;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_2;
			q = p + (k & 1);
			k >>= 1;
			p = tree[(4096 * 2) + (int) q];;
			if ((int) p >= 0)
				goto chk_offset_2;
			q = p + (k & 1);
			k >>= 1 + 0;
			p = tree[(4096 * 2) + (int) q];;	/* scan bits 20..23 */



			if (p == NULL || (offset = s - p) > 4095)
				goto update;
			s += 3;
			p += 3;
			goto cont;


		      chk_offset_2:

			if (p == NULL || (offset = s - p) > 4095)
				goto update;
			s += 2;
			p += 2;
			if (*p++ != *s++) {
				goto add;
			} else {
				goto cont;
			}

		      chk_offset_1:

			if (p == NULL || (offset = s - p) > 4095)
				goto update;
			s += 1;
			p += 1;
			if (*p++ != *s++) {
				goto add;
			} else {
				if (*p++ != *s++) {
					goto add;
				} else {
					goto cont;
				}
			}

		      chk_offset_0:

			if (p == NULL || (offset = s - p) > 4095)
				goto update;
			s += 0;
			p += 0;

			if (*p++ != *s++) {
				goto add;
			} else {
				if (*p++ != *s++) {
					goto add;
				} else {
					if (*p++ != *s++) {
						goto add;
					} else {
						goto cont;
					}
				}
			}

			/* check offsets */
		      add:

			if (lastnode < 0) {
				tree[(4096 * 2) + (int) q] = (UBYTE *) lastnode;
				q = (UBYTE *) lastnode + (k & 1);
				tree[((4096 * 2) + (int) q) ^ 1] = 0;
				lastnode += 2;
			}
		      update:

			tree[(4096 * 2) + (int) q] = p_src;
			goto literal;

		      cont:

			tree[(4096 * 2) + (int) q] = p_src;
/*
   *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ ||
   *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || *p++ != *s++ || s++;
 */
			len = s - p_src - 1;
			*p_dst++ = (UBYTE) (((offset & 0xF00) >> 4) + (len - 1));
			*p_dst++ = (UBYTE) (offset & 0xFF);
			p_src += len;
			control = (control >> 1) | 0x8000;
			control_bits++;
			continue;

		      literal:

			*p_dst++ = *p_src++;
			control >>= 1;
			control_bits++;
		} while (--unroll);

		/* Flush Control Bits */
		if (control_bits == 16) {
			*p_control = (UBYTE) (control & 0xFF);
			*(p_control + 1) = (UBYTE) (control >> 8);
			p_control = p_dst;
			p_dst += 2;
			control = control_bits = 0;
		}
	}

	control >>= 16 - control_bits;
	*p_control++ = (UBYTE) (control & 0xFF);
	*p_control++ = (UBYTE) (control >> 8);
	if (p_control == p_dst)
		p_dst -= 2;
	*p_dst_len = p_dst - p_dst_first;

      overrun:
	FAST_LONG_COPY(p_src_first, p_dst_first + 4, src_len);
	*p_dst_first = 1;
	*p_dst_len = src_len + 4;

	JLIB_LEAVE
}


/* Input  : Specify input block using p_src_first and src_len.          */
/* Input  : Point p_dst_first to the start of the output zone.          */
/* Input  : Point p_dst_len to a ULONG to receive the output length.    */
/* Input  : Input block and output zone must not overlap. User knows    */
/* Input  : upperbound on output block length from earlier compression. */
/* Input  : In any case, maximum expansion possible is eight times.     */
/* Output : Length of output block written to *p_dst_len.               */
/* Output : Output block in Mem[p_dst_first..p_dst_first+*p_dst_len-1]. */
/* Output : Writes only  in Mem[p_dst_first..p_dst_first+*p_dst_len-1]. */

/* LZRW1 decompression routine: */
void lz_decompress(UBYTE * p_src_first, long src_len, UBYTE * p_dst_first, long *p_dst_len)
{
	ULONG controlbits = 0, control = 0;
	UBYTE *p_src = p_src_first + 4, *p_dst = p_dst_first, *p_src_post = p_src_first + src_len;

	JLIB_ENTER("lz_decompress");

	if (*p_src_first == 1) {
		FAST_LONG_COPY(p_src_first + 4, p_dst_first, src_len - 4);
		*p_dst_len = src_len - 4;

		JLIB_LEAVE;
		return;
	}
	while (p_src != p_src_post) {
		UBYTE tmp;

		if (controlbits == 0) {
			tmp = *p_src;
			p_src++;
			control = tmp;
			tmp = *p_src;
			p_src++;
			control |= (tmp << 8);
			controlbits = 16;
		}
		if (control & 1) {
			ULONG offset, len;
			UBYTE *p;

			tmp = *p_src;
			offset = (tmp & 0xF0) << 4;
			tmp = *p_src;
			p_src++;
			len = 1 + (tmp & 0xF);
			tmp = *p_src;
			p_src++;
			offset += tmp & 0xFF;
			p = p_dst - offset;
			while (len--) {
				*p_dst = *p;
#ifdef DEBUG_JLB
				printf("read %d\n", *p_dst);
#endif
				++p;
				++p_dst;
			}
		} else {
			*p_dst = *p_src;
#ifdef DEBUG_JLB
			printf("read %d\n", *p_dst);
#endif
			++p_dst;
			++p_src;
		}
		control >>= 1;
		controlbits--;
	}
	*p_dst_len = p_dst - p_dst_first;


	JLIB_LEAVE
}
