/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <stdlib.h>
#include <jlib.h>


/*+------------------------------------------------------------------------+ */
/*|Free the storage used by an image to the O/S.                           | */
/*+------------------------------------------------------------------------+ */
image *image_free(image * img)
{
	JLIB_ENTER("image_free");

#ifndef JLIB_PRODUCTION
	jlib_check_image(img);
#endif

	buff_free(IMG_BUFFER(img));	
	free(IMG_PALETTE(img));
	free(img);

	JLIB_LEAVE;
	return NULL;
}


/*+------------------------------------------------------------------------+ */
/*|Set up a fake buffer for an image                                       | */
/*+------------------------------------------------------------------------+ */
void image_setup(image * img)
{
	JLIB_ENTER("image_setup");

	IMG_BUFFER(img) = buff_init(IMG_WIDTH(img),IMG_HEIGHT(img));

	IMG_DATA_PTR(img) = IMG_BUFFER(img)->buffer;
	JLIB_LEAVE;
}