/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>

/* NOTE: You should use the jx_font package for any serious text work */

/* How many bits a character uses */
#define USED_SPACE (CHAR_WIDTH('a')*CHAR_HEIGHT('a'))

static int getbit(UBYTE * set, int number);

/*+------------------------------------------------------------------------+ */
/*|Draw a character in a buffer at x,y in color c without clipping         | */
/*+------------------------------------------------------------------------+ */
JINLINE void buff_draw_charNC(buffer_rec * buff, UBYTE letter, int x, int y, UBYTE c)
{
	UBYTE *buffer;
	int width, height, i;

	JLIB_ENTER("buff_draw_charNC()");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	buffer = B_OFFSET(buff, y) + x;

	if (!HAS_FONT(letter)) {
		JLIB_SPRINTF("%d Non Printable.", letter);
		JLIB_LEAVE;
		return;
	}

	i = ((letter - 32) * USED_SPACE);	/* set i to point to letter data */

	for (height = CHAR_HEIGHT(letter); height != 0; height--) {
		for (width = CHAR_WIDTH(letter); width != 0; width--) {
			if (getbit(__font_data, i)) {
				*buffer = c;
			}
			i++;
			buffer++;
		}
		buffer += B_X_SIZE(buff) - CHAR_WIDTH(letter);
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Draw a character in a buffer at x,y in color c with clipping            | */
/*+------------------------------------------------------------------------+ */
JINLINE void buff_draw_char(buffer_rec * buff, UBYTE letter, int x, int y, UBYTE c)
{
	UBYTE width, height, a, b;
	int i;

	JLIB_ENTER("buff_draw_char");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	if (!HAS_FONT(letter)) {
		JLIB_SPRINTF("%d non printable.", letter);
		JLIB_LEAVE;
		return;
	}
	width = CHAR_WIDTH(letter);
	height = CHAR_HEIGHT(letter);

	/* Clip */
	if ((x > B_CX2(buff)) || (y > B_CY2(buff)) ||
	   (x + width < B_CX1(buff)) || (y + height < B_CY1(buff))) {
		JLIB_LEAVE;
		return;
	}

	if ((x + width <= B_CX2(buff)) && (y + height <= B_CY2(buff)) &&
	   (x >= B_CX1(buff)) && (y >= B_CY1(buff))) {
		buff_draw_charNC(buff, letter, x, y, c);
		JLIB_LEAVE;
		return;
	}
	i = ((letter - 32) * USED_SPACE);	/* set i to point to letter data */

	/* Draw */
	for (a = 0; a < height; a++) {
		for (b = 0; b < width; b++) {
			if (getbit(__font_data, i)) {
				buff_draw_point(buff, x + b, y + a, c);
			}
			i++;
		}
	}

	JLIB_LEAVE;
}


/*+-------------------------------------------------------------------------+ */
/*|Draw a string in buff at x,y in color c without clipping                 | */
/*+-------------------------------------------------------------------------+ */
void buff_draw_stringNC(buffer_rec * buff, char *string, int x, int y, UBYTE c)
{
	JLIB_ENTER("buff_draw_stringNC");

	while (*string != '\0') {
		if (HAS_FONT(*string)) {
			buff_draw_charNC(buff, *string, x, y, c);
			x += CHAR_WIDTH(*string);
		}
		string++;
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Draw a string in buff at x,y in color c with clipping.                  | */
/*+------------------------------------------------------------------------+ */
void buff_draw_string(buffer_rec * buff, char *string, int x, int y, UBYTE c)
{
	int width, height;

	JLIB_ENTER("buff_draw_string");

#ifndef JLIB_PRODUCTION
	if (string == NULL)
		jlib_exit(jlib_msg(JLIB_ENULL));
	jlib_check_buffer(buff);
#endif

	width = B_MAX_X(buff);
	height = B_MAX_Y(buff);

	/* Clip */
	if ((x > B_CX2(buff)) || (y > B_CY2(buff)) ||
	   (y + CHAR_HEIGHT('a') < B_CY1(buff))) {
		JLIB_LEAVE;
		return;
	}

	while (*string != '\0') {
		if (HAS_FONT(*string)) {
			buff_draw_char(buff, *string, x, y, c);
			x += CHAR_WIDTH(*string);
		}
		string++;
	}

	JLIB_LEAVE;
}


static int getbit(UBYTE * set, int number)
{
	if (number) {
		set += (number / 8);
		return (*set & (1 << (number % 8))) != 0;
	}
	return ((*set) & 1) != 0;
}