/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


/*+------------------------------------------------------------------------+ */
/*|draw a box with corners x1, y1 to x2 , y2 in color c without clipping   | */
/*+------------------------------------------------------------------------+ */
JINLINE void buff_draw_boxNC(buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
	int boxwidth;
	UBYTE *buffer;

	JLIB_ENTER("buff_draw_boxNC");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	if (x1 > x2)	JLIB_SWAP(x1, x2);
	if (y1 > y2)	JLIB_SWAP(y1, y2);

	boxwidth = x2 - x1 + 1;
	buffer = B_OFFSET(buff, y1) + x1;

	y2 -= y1;

	/* Top */
	if (boxwidth < 17) {
		MEM_STORE_SHORT(buffer, c, boxwidth);
	}
	else {
		MEM_STORE_LONG(buffer, c, boxwidth);
	}
		
	boxwidth--;

	/* Sides */
	while (y2--) {
		buffer += B_X_SIZE(buff);
		*buffer = c;
		buffer[boxwidth] = c;
	}

	/* Bottom */
	boxwidth++;
	if (boxwidth < 17) {
		MEM_STORE_SHORT(buffer, c, boxwidth);
	}
	else {
		MEM_STORE_LONG(buffer, c, boxwidth);
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|draw a box with corners x1, y1 to x2 , y2 in color c with clipping      | */
/*+------------------------------------------------------------------------+ */
void buff_draw_box(buffer_rec * buff, int x1, int y1, int x2, int y2, UBYTE c)
{
	UBYTE *buffer;
	int width, clipped = 0;

	JLIB_ENTER("buff_draw_box");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	/* Clip */
	if (x1 > x2)	JLIB_SWAP(x1, x2);
	if (y1 > y2)	JLIB_SWAP(y1, y2);

	if (x2 > B_CX2(buff)) {
		x2 = B_CX2(buff);
		clipped |= C_RIGHT;
	}
	else
		if (x2 < B_CX1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y2 > B_CY2(buff)) {
		y2 = B_CY2(buff);
		clipped |= C_DOWN;
	}
	else
		if (y2 < B_CY1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (x1 < B_CX1(buff)) {
		x1 = B_CX1(buff);
		clipped |= C_LEFT;
	}
	else
		if (x1 > B_CX2(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y1 < B_CY1(buff)) {
		y1 = B_CY1(buff);
		clipped |= C_UP;
	}
	else
		if (y1 > B_CY2(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (!clipped) {
		buff_draw_boxNC(buff, x1, y1, x2, y2, c);
		JLIB_LEAVE;
		return;
	}

	width = x2 - x1 + 1;

	/* Top */
	if (!(clipped & C_UP)) {
		buffer = B_OFFSET(buff, y1) + x1;

		if (width < 17) {
			MEM_STORE_SHORT(buffer, c, width);
		}
		else {
			MEM_STORE_LONG(buffer, c, width);
		}
	}

	/* Bottom */
	if (!(clipped & C_DOWN)) {
		buffer = B_OFFSET(buff, y2) + x1;

		if (width < 17) {
			MEM_STORE_SHORT(buffer, c, width);
		}
		else {
			MEM_STORE_LONG(buffer, c, width);
		}
	}

	/* Sides */
	buffer = B_OFFSET(buff, y1) + x1;
	y2 = y2 - y1 + 1;
	width--;

	switch (clipped & 0x3) {
	case 0:
		/* Draw Both */
		while (y2--) {
			*buffer = c;
			buffer[width] = c;
			buffer += B_X_SIZE(buff);
		}
		break;
	case C_LEFT:
		/* Draw Right */
		buffer += width;	/* Fall through to draw */
	case C_RIGHT:
		/* Draw Left */
		while (y2--) {
			*buffer = c;
			buffer += B_X_SIZE(buff);
		}
		break;
	}

	JLIB_LEAVE;
}