/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
/* make a sprite out of a twilight dreams sprite file */
/*
** The twilight dreams sprite editor is available at x2ftp.oulu.fi ....
** I think thats where I got it from,  anyway....
** As far as I am aware it is onlly available for dos.
**
*/

#include <stdio.h>


int main(int argc, char *argv[])
{
  FILE *fp,*new,*pal;
  int i,j;
  unsigned short a;
  unsigned char w,h;

  if(argc!=4){
	      printf("td2spr - create a sprite from a twilight dreams file.\n");
	      printf("Usage: td2spr <infile> <outfile1> <outfile2>\n");
	      printf("Where: <infile>  = file to get sprites from (include extn)\n");
	      printf("Where: <outfile1> = file to put sprites into (include .SPR extn)\n");
	      printf("Where: <outfile2> = file to put palette into (include .PAL extn)\n");
	      exit(-1);
  }

  if((fp=fopen(argv[1],"rb"))==NULL){
     printf(" ERROR: Could not open file %s for reading.",argv[1]);
     exit(-1);
  }

  if((new=fopen(argv[2],"wb"))==NULL){
     printf(" ERROR: Could not open file %s for writing.",argv[2]);
     exit(-1);
  }

  if((pal=fopen(argv[3],"wb"))==NULL){
     printf(" ERROR: Could not open file %s for writing.",argv[2]);
     exit(-1);
  }

  a = (unsigned short)fgetc(fp);
  fwrite(&a,sizeof(unsigned short),1,new);

  for(/* nothing */;a>0;a--){

      /* get width and height */
      w=fgetc(fp);
      h=fgetc(fp);

      /* write them out */
      fputc(w,new);
      fputc(h,new);


      /* copy out the data to the sprite file */
      for(i=0;i<h;i++){
	  for(j=0;j<w;j++){
	      fputc(fgetc(fp),new);
	  }
      }

      /* assume a bounding rectangle of the whole sprite */
      fputc(1,new); /* one rect */

      fputc(0,new);
      fputc(0,new);      /* 0,0 to w,h */
      fputc(w,new);
      fputc(h,new);


      /* skip name */
      fseek(fp,10,SEEK_CUR);
  }

  printf("Sprite file %s written.\n",argv[2]);

  /* now write out palette file */
  for(i=0;i<768;i++){
      fputc(fgetc(fp),pal);
  }

  printf("Palette file %s written.\n",argv[3]);


  fclose(fp);
  fclose(new);
  fclose(pal);

  return (0);      
}
