/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>


#define FAST_2_MUL(x) ((x)<<1)
#define FAST_3_MUL(x) (((x)<<1)+x)
#define FAST_4_DIV(x) ((x)>>2)


/*+------------------------------------------------------------------------+ */
/*|Draw an ellipse into a buffer in color c without clipping               | */
/*+------------------------------------------------------------------------+ */
void buff_draw_ellipseNC(buffer_rec * buff, int x0, int y0, int a, int b, UBYTE c)
{
	int x, y, y1, aa, bb, d, g, h;
	UBYTE *dest;
	
	JLIB_ENTER("buff_draw_ellipseNC");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	aa = a * a;
	bb = b * b;

	h = (FAST_4_DIV(aa)) - b * aa + bb;
	g = (FAST_4_DIV(9 * aa)) - (FAST_3_MUL(b * aa)) + bb;
	x = 0;
	y = b;

	while (g < 0) {
		dest = B_OFFSET(buff, y0 - y) + x0;
		*(dest - x) = c;
		*(dest + x) = c;
		dest = B_OFFSET(buff, y0 + y) + x0;
		*(dest - x) = c;
		*(dest + x) = c;

		if (h < 0) {
			d = ((FAST_2_MUL(x)) + 3) * bb;
			g += d;
		}
		else {
			d = ((FAST_2_MUL(x)) + 3) * bb - FAST_2_MUL((y - 1) * aa);
			g += (d + (FAST_2_MUL(aa)));
			--y;
		}

		h += d;
		++x;
	}

	y1 = y;
	h = (FAST_4_DIV(bb)) - a * bb + aa;
	x = a;
	y = 0;

	while (y <= y1) {
		dest = B_OFFSET(buff, y0 - y) + x0;
		*(dest - x) = c;
		*(dest + x) = c;
		dest = B_OFFSET(buff, y0 + y) + x0;
		*(dest - x) = c;
		*(dest + x) = c;

		if (h < 0)
			h += ((FAST_2_MUL(y)) + 3) * aa;
		else {
			h += (((FAST_2_MUL(y) + 3) * aa) - (FAST_2_MUL(x - 1) * bb));
			--x;
		}
		++y;
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Draw an ellipse into a buffer in color c with clipping                  | */
/*+------------------------------------------------------------------------+ */
void buff_draw_ellipse(buffer_rec * buff, int x0, int y0, int a, int b, UBYTE c)
{
	int x, y, y1, aa, bb, d, g, h, clipped = 0;
	UBYTE *dest;

	JLIB_ENTER("buff_draw_ellipse");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	/* Clip */
	if ((a < 1) || (b < 1)) {
		JLIB_LEAVE;
		return;
	}

	if (x0 + a > B_CX2(buff))
		clipped = 1;
	else
		if (x0 + a < B_CX1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y0 + b > B_CY2(buff))
		clipped = 1;
	else
		if (y0 + b < B_CY1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (x0 - a < B_CX1(buff))
		clipped = 1;
	else
		if (x0 - a > B_CX2(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y0 - b < B_CY1(buff))
		clipped = 1;
	else
		if (y0 - b > B_CY2(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (a == 1) {
		buff_draw_v_line(buff, x0, y0 - b, y0 + b, c);	
		JLIB_LEAVE;
		return;
	}	

	if (b == 1) {
		buff_draw_h_line(buff, x0 - a, y0, x0 + a, c);	
		JLIB_LEAVE;
		return;
	}	

	if (!clipped) {
		buff_draw_ellipseNC(buff, x0, y0, a, b, c);
		JLIB_LEAVE;
		return;
	}

	aa = a * a;
	bb = b * b;

	h = (FAST_4_DIV(aa)) - b * aa + bb;
	g = (FAST_4_DIV(9 * aa)) - (FAST_3_MUL(b * aa)) + bb;
	x = 0;
	y = b;

	while (g < 0) {
		if ((y0 - y >= B_CY1(buff)) & (y0 - y <= B_CY2(buff))) {
			dest = B_OFFSET(buff, y0 - y) + x0;
			if ((x0 - x >= B_CX1(buff)) & (x0 - x <= B_CX2(buff)))
				*(dest-x)=c;
			if ((x0 + x >= B_CX1(buff)) & (x0 + x <= B_CX2(buff)))
				*(dest+x)=c;
		}
		if ((y0 + y >= B_CY1(buff)) & (y0 + y <= B_CY2(buff))) {
			dest = B_OFFSET(buff, y0 + y) + x0;
			if ((x0 - x >= B_CX1(buff)) & (x0 - x <= B_CX2(buff)))
				*(dest-x)=c;
			if ((x0 + x >= B_CX1(buff)) & (x0 + x <= B_CX2(buff)))
				*(dest+x)=c;
		}

		if (h < 0) {
			d = ((FAST_2_MUL(x)) + 3) * bb;
			g += d;
		}
		else {
			d = ((FAST_2_MUL(x)) + 3) * bb - FAST_2_MUL((y - 1) * aa);
			g += (d + (FAST_2_MUL(aa)));
			--y;
		}

		h += d;
		++x;
	}

	y1 = y;
	h = (FAST_4_DIV(bb)) - a * bb + aa;
	x = a;
	y = 0;

	while (y <= y1) {
		if ((y0 - y >= B_CY1(buff)) & (y0 - y <= B_CY2(buff))) {
			dest = B_OFFSET(buff, y0 - y) + x0;
			if ((x0 - x >= B_CX1(buff)) & (x0 - x <= B_CX2(buff)))
				*(dest-x)=c;
			if ((x0 + x >= B_CX1(buff)) & (x0 + x <= B_CX2(buff)))
				*(dest+x)=c;
		}
		if ((y0 + y >= B_CY1(buff)) & (y0 + y <= B_CY2(buff))) {
			dest = B_OFFSET(buff, y0 + y) + x0;
			if ((x0 - x >= B_CX1(buff)) & (x0 - x <= B_CX2(buff)))
				*(dest-x)=c;
			if ((x0 + x >= B_CX1(buff)) & (x0 + x <= B_CX2(buff)))
				*(dest+x)=c;
		}

		if (h < 0)
			h += ((FAST_2_MUL(y)) + 3) * aa;
		else {
			h += (((FAST_2_MUL(y) + 3) * aa) - (FAST_2_MUL(x - 1) * bb));
			--x;
		}
		++y;
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Draw a filled ellipse into a buffer in color c without clipping         | */
/*+------------------------------------------------------------------------+ */
void buff_filled_ellipseNC(buffer_rec * buff, int x0, int y0, int a, int b, UBYTE c)
{
	int x, y, y1, aa, bb, d, g, h;

	JLIB_ENTER("buff_filled_ellipseNC");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	aa = a * a;
	bb = b * b;

	h = (FAST_4_DIV(aa)) - b * aa + bb;
	g = (FAST_4_DIV(9 * aa)) - (FAST_3_MUL(b * aa)) + bb;
	x = 0;
	y = b;

	while (g < 0) {
		buff_draw_h_lineNC(buff, x0 - x, y0 + y, x0 + x, c);
		buff_draw_h_lineNC(buff, x0 - x, y0 - y, x0 + x, c);

		if (h < 0) {
			d = ((FAST_2_MUL(x)) + 3) * bb;
			g += d;
		}
		else {
			d = ((FAST_2_MUL(x)) + 3) * bb - FAST_2_MUL((y - 1) * aa);
			g += (d + (FAST_2_MUL(aa)));
			--y;
		}

		h += d;
		++x;
	}

	y1 = y;
	h = (FAST_4_DIV(bb)) - a * bb + aa;
	x = a;
	y = 0;

	while (y <= y1) {
		buff_draw_h_lineNC(buff, x0 - x, y0 + y, x0 + x, c);
		buff_draw_h_lineNC(buff, x0 - x, y0 - y, x0 + x, c);

		if (h < 0)
			h += ((FAST_2_MUL(y)) + 3) * aa;
		else {
			h += (((FAST_2_MUL(y) + 3) * aa) - (FAST_2_MUL(x - 1) * bb));
			--x;
		}
		++y;
	}

	JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|draw a filled ellipse into a buffer in color c with clipping.           | */
/*+------------------------------------------------------------------------+ */
void buff_filled_ellipse(buffer_rec * buff, int x0, int y0, int a, int b, UBYTE c)
{
	int x, y, y1, aa, bb, d, g, h, clipped = 0;

	JLIB_ENTER("buff_filled_ellipse");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	/* Clip */
	if ((a < 1) || (b < 1)) {
		JLIB_LEAVE;
		return;
	}

	if (x0 + a > B_CX2(buff))
		clipped = 1;
	else
		if (x0 + a < B_CX1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y0 + b > B_CY2(buff))
		clipped = 1;
	else
		if (y0 + b < B_CY1(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (x0 - a < B_CX1(buff))
		clipped = 1;
	else
		if (x0 - a > B_CX2(buff)) {
			JLIB_LEAVE;
			return;
		}

	if (y0 - b < B_CY1(buff))
		clipped = 1;
	else
		if (y0 - b > B_CY2(buff)) {
			JLIB_LEAVE;
			return;
		}
	
	if (a == 1) {
		buff_draw_v_line(buff, x0, y0 - b, y0 + b, c);	
		JLIB_LEAVE;
		return;
	}	

	if (b == 1) {
		buff_draw_h_line(buff, x0 - a, y0, x0 + a, c);	
		JLIB_LEAVE;
		return;
	}	

	if (!clipped) {
		buff_filled_ellipseNC(buff, x0, y0, a, b, c);
		JLIB_LEAVE;
		return;
	}	

	aa = a * a;
	bb = b * b;

	h = (FAST_4_DIV(aa)) - b * aa + bb;
	g = (FAST_4_DIV(9 * aa)) - (FAST_3_MUL(b * aa)) + bb;
	x = 0;
	y = b;

	while (g < 0) {
		buff_draw_h_line(buff, x0 - x, y0 + y, x0 + x, c);
		buff_draw_h_line(buff, x0 - x, y0 - y, x0 + x, c);

		if (h < 0) {
			d = ((FAST_2_MUL(x)) + 3) * bb;
			g += d;
		}
		else {
			d = ((FAST_2_MUL(x)) + 3) * bb - FAST_2_MUL((y - 1) * aa);
			g += (d + (FAST_2_MUL(aa)));
			--y;
		}

		h += d;
		++x;
	}

	y1 = y;
	h = (FAST_4_DIV(bb)) - a * bb + aa;
	x = a;
	y = 0;

	while (y <= y1) {
		buff_draw_h_line(buff, x0 - x, y0 + y, x0 + x, c);
		buff_draw_h_line(buff, x0 - x, y0 - y, x0 + x, c);

		if (h < 0)
			h += ((FAST_2_MUL(y)) + 3) * aa;
		else {
			h += (((FAST_2_MUL(y) + 3) * aa) - (FAST_2_MUL(x - 1) * bb));
			--x;
		}
		++y;
	}

	JLIB_LEAVE;
}