#ifndef _hmod_sb_set_h
#define _hmod_sb_set_h
/*sb_set.h, get sb's settings from the environment variable 'BLASTER' */

struct
{
 unsigned int base,irq,dma,hdma;
} sb_settings;

int sb_get_settings() /* OUT: -1 failed, 0 got 'em */
{
 int len,pos;
 char *blaster=getenv("BLASTER");
 if (blaster==NULL) {strcat(error,"env. read: no blaster env. variable\n"); return -1;}
 sb_settings.base=0; sb_settings.irq=0; sb_settings.dma=0; sb_settings.hdma=0;

 len=strlen(blaster);
 pos=strcspn(blaster,"A");
 if (pos>=len) pos=strcspn(blaster,"a");

 if (pos>=len) {strcat(error,"env. read: no base. (A220 etc.)\n"); return -1;} /*no base*/
 sb_settings.base=(blaster[pos+1]-48)*0x100+(blaster[pos+2]-48)*0x010+(blaster[pos+3]-48);
 if ( (sb_settings.base<0x210) || (sb_settings.base>0x280) ) {strcat(error,"env read: no base. (A220 etc.)\n"); return -1;} /*no base*/

/* printf("sb at %Xh\n",sb_settings.base);*/

 pos=strcspn(blaster,"I");
 if (pos>=len) pos=strcspn(blaster,"i");

 if (pos>=len) {strcat(error,"env. read: no irq. (I5 etc.)\n"); return -1;} /*no irq*/
 sb_settings.irq=(blaster[pos+1]-48);
 if ( (sb_settings.irq==1) && (blaster[pos+2]=='0') ) sb_settings.irq=10;
 if ( (sb_settings.irq!=2)&&(sb_settings.irq!=3)&&(sb_settings.irq!=5)
      &&(sb_settings.irq!=7)&&(sb_settings.irq!=10) ) {strcat(error,"env. read: no irq. (I5 etc.)\n"); return -1;} /*no irq*/

/* printf("irq %u\n",sb_settings.irq);*/

 pos=strcspn(blaster,"D");
 if (pos>=len) pos=strcspn(blaster,"d");

 if (pos>=len) {strcat(error,"env. read: no dma. (D1 etc.)\n"); return -1;} /*no dma*/
 sb_settings.dma=(blaster[pos+1]-48);
 if ( (sb_settings.dma!=0)&&(sb_settings.dma!=1)&&(sb_settings.dma!=3) )
  {strcat(error,"env. read: no dma. (D1 etc.)\n"); return -1;} /*no dma*/

/*printf("dma %u\n",sb_settings.dma);*/

 pos=strcspn(blaster,"H");
 if (pos>=len) pos=strcspn(blaster,"h");

 if (pos<len) { /*16 bit dma does exist*/
  sb_settings.hdma=(blaster[pos+1]-48);
  if ( (sb_settings.hdma!=5)&&(sb_settings.hdma!=6)&&(sb_settings.hdma!=7) )
   sb_settings.hdma=0xFF; /* we can live without one */

/*  printf("hdma %u\n",sb_settings.hdma); */
 }

 return 0;
}
/* end of sb_set.h */
#endif
