#ifndef _hmod_sb_h
#define _hmod_sb_h
/* sb.c, sound blaster stuff */

struct
{
 int dma_buf_size,dma_buf_segment,dma_buf_offset,dma_buf_selector;
 unsigned int base,irq,dma,hdma,playspeed;
 unsigned int interrupts; /* the number of mixing interrupts occured */
 unsigned char airq,pic,pageport,istam,istom,dstam,dstom,dmode;
 int dsp_reset,dsp_read_data,dsp_write_data,dsp_write_status,dsp_data_avail;
 _go32_dpmi_seginfo info,vanha;
 unsigned char installed;
 unsigned int dspversion; /* 8.8 bits. bcd stylish */

 int autoinit; /*0 no; 1 yes; dspversion>2.0               */
 int _16bit;  /*0 no; 1 yes; dspversion>4.0, 4<high dma<8 */
 int stereo; /*0 no; 1 yes; for sb16 and sb pro          */

 unsigned char dmamaskport,dmaclrptrport,dmamodeport,
               dmabaseaddrport,dmacountport;
 int ackport;
 int dmalen;
} sb;

void writedsp(unsigned char value)
{
 int nerve=300000;
 __asm__ __volatile__ ( /* dirty */
 "pushfl
  cli");
 while ( ((inportb(sb.dsp_write_status)&0x80)!=0)&&(nerve>0) ) (nerve--);
 outportb(sb.dsp_write_data,value);
 __asm__ __volatile__ ("popfl"); /* dirty */
}

unsigned char readdsp()
{
 int nerve=300000;
 unsigned char resultti;
 __asm__ __volatile__ ( /* dirty */
 "pushfl;
  cli");
 while ( ((inportb(sb.dsp_data_avail)&0x80)==0)&&(nerve>0) ) (nerve--);
 resultti=inportb(sb.dsp_read_data);
 __asm__ __volatile__ ("popfl"); /* dirty */
 return resultti;
}

void speakeron()
{
 writedsp(0xD1);
}

void speakeroff()
{
 writedsp(0xD3);
}

void dmacontinue()
{
 if (sb._16bit==1) writedsp(0xd6);
  else writedsp(0xD4);
}

void dmastop()
{
 if (sb._16bit==1) writedsp(0xd5);
  else writedsp(0xD0);
}

void odota()
{
 int nerve=300000;
 __asm__ __volatile__ ( /* dirty */
 "pushfl
  cli");
 while ( ((inportb(sb.dsp_data_avail)&0x80)==0)&&(nerve>0) ) (nerve--);
 __asm__ __volatile__ ("popfl"); /* dirty */
}

void retrace() /* used as delay */
{
 while( ((inportb(0x3DA)&8)==0) );
 while( ((inportb(0x3DA)&8)!=0) );
}

signed int resetdsp(unsigned int epatoivo) /* 0 success, -1 failed. */
{
 unsigned int eptoiv=0;
 signed int reset=-1;
 sb.dsp_reset=sb.base+0x6;
 sb.dsp_read_data=sb.base+0xA;
 sb.dsp_write_data=sb.base+0xC;
 sb.dsp_write_status=sb.base+0xC;
 sb.dsp_data_avail=sb.base+0xE;
 __asm__ __volatile__ ("cli");
 disable();
 while ((reset==-1)&&(eptoiv<=epatoivo))
  {
   eptoiv++;
   outportb(sb.dsp_reset,1);
   retrace();
   retrace();
   outportb(sb.dsp_reset,0);
   retrace();
   odota();
   if (readdsp()==0xAA) reset=0; else reset=-1;
  }
 __asm__ __volatile__ ("sti");
 enable();
 return reset;
}

unsigned int verify_freq(unsigned int freq)
{
 if (freq<5000) freq=5000;/*all sb versions (well, some old sndblstrs can do less:) */

 if ( ((sb.autoinit==0)||(sb.dspversion<=0x200)) && (freq>21739) ) freq=21739; /*sb 1.0 and sb 1.5*/
 if ( (sb.stereo==1) && (sb.dspversion<0x401) && (freq>21739) ) freq=21739; /* sb pro STEREO */

 if ( (sb.dspversion<0x401) && (freq>43478) ) freq=43478; /* sb pro and sb 2.0 */
 /* I'm not sure exactly how high pro and 2.0 can go; this is a secure value. */

 if (freq>45454) freq=45454; /* sb 16 can however handle even this */
 return freq;
}

#define lo(tmp) ((tmp)&0xFF)
#define hi(tmp) (((tmp)>>8)&0xFF)

int setfreq(unsigned int freq) /*returns the frequency set.*/
{
 signed int t;
 unsigned int sb_pro_stereo=1;

 freq=verify_freq(freq);

 if ((sb.dspversion>0x400)&&(sb.autoinit==1))
  { /*sb 16 has an option to setup the playspeed directly. use it if possible.*/
   writedsp(0x41);
   writedsp(hi(freq)); /*hi*/
   writedsp(lo(freq));    /*lo*/
  }
 else
  {/* normal set sb time constant. */
   if ( (sb.stereo==1) && (sb.dspversion<0x401) ) sb_pro_stereo=2;
    else sb_pro_stereo=1;
   t=(unsigned char)((256-(1000000/(freq*sb_pro_stereo)))&255);
   writedsp(0xD1);
   writedsp(0x40);
   writedsp((unsigned char)(t));
   freq=((signed int)(-1000000)/(signed int)(t-256));
   freq/=sb_pro_stereo;
   /* calculate the "real" value. rather pedantic. */
  }
 return freq;
}

void setmixer(unsigned char index,unsigned char value)
{
 outportb(sb.base+0x04,index);
 outportb(sb.base+0x05,value);
}

volatile void playback()
{
 unsigned int page,offset,len;
 unsigned char commandb,modeb;

 /* calculate dma controller's setup (==page&offset) */
 /* the offset must be even. the dma buffer must not cross 64kB boundaries */
 /* both of the above conditions are taken care in sbstaff.h */
 offset=((unsigned int)sb.dma_buf_segment<<4)+(unsigned int)sb.dma_buf_offset; /*typecasting is fun.*/
 if (sb._16bit==1) offset/=2; /*thank you midas guys, it actually is the starting word not the byte.*/
 page=((unsigned int)((unsigned int)sb.dma_buf_segment+((unsigned int)sb.dma_buf_offset>>4)))>>12;

 __asm__ __volatile__ ("cli");
 disable(); /* don't disturb us while we're messing with the ports */

 outportb(sb.dmamaskport,sb.dstom); /* mask dma channel (off==stop it) */
 outportb(sb.dmaclrptrport,0); /* clear flipflop */
 outportb(sb.dmamodeport,sb.dmode);  /* write the mode. */
 outportb(sb.dmabaseaddrport,lo(offset)); /* write address LOw */
 outportb(sb.dmabaseaddrport,hi(offset)); /* write address HIgh */
 len=sb.dmalen;
 if (sb.stereo==1) len*=2;
 outportb(sb.dmacountport,lo(len-1)); /* write transfer length LOw */
 outportb(sb.dmacountport,hi(len-1)); /* write transfer length HIgh */
 outportb(sb.pageport,page); /* write page number */
 outportb(sb.dmamaskport,sb.dstam); /* mask the channel with startmask == activate it */
 if ((sb.dspversion>0x400)&&(sb.autoinit==1)) /* now program the sb */
  { /* use SB16 "generic dac" -command */
/*   printf("(using sb16 dac commands.)\n"); */
   sb.playspeed=setfreq(sb.playspeed); /* set output frequency */
   commandb=2|4; /* enable fifo, use autoinit dma mode */
   if (sb._16bit==1) commandb|=16|32|128; /*16-bit*/
                else commandb|=128|64; /*8-bit*/
   if (sb._16bit==1) modeb=16; /*signed*/
     else modeb=0; /* unsigned */
   /*16-bit modes use signed, in 8-bit mode we are using unsigned values*/
   if (sb.stereo==1) modeb|=32; /* set stereo mode */
   writedsp(commandb); /* write command byte */
   writedsp(modeb); /* write mode byte */
   len=sb.dma_buf_size;
   if (sb.stereo==1) len*=2;
   writedsp(lo(len-1)); /* write transfer length LOw */
   writedsp(hi(len-1)); /* write transfer length HIgh */
  }
 else
  {
/*   printf("using standard sb dac commands.\n"); */
   speakeron(); /* turn on speaker */
   sb.playspeed=setfreq(sb.playspeed); /* set'n'get output frequency */
   if (sb.autoinit==1)
    {
     if (sb.stereo==1) /* sb pro's stereo */
      { /* let's reprogram the mixer */
       outportb(sb.base+0x04,0x0E);
       modeb=inportb(sb.base+0x05);/*0x22 is only a mask*/
       setmixer(0x0E,modeb|0x22); /*sb pro ONLY: stereo, no filter*/
      }
     if ((sb.stereo==0)&&(sb.dspversion>=0x300)) /* sb pro's mono */
      { /* let's reprogram the mixer */
       outportb(sb.base+0x04,0x0E); /* get the old settings */
       modeb=inportb(sb.base+0x05);
       setmixer(0x0E,(modeb&0xFD)|0x20); /*sb pro: mono, no filter*/
      }
/*     printf("playing 8bit autoinited to be exact.\n"); */
     writedsp(0x48); /* set dma block size, SB 2.0 */
     len=sb.dma_buf_size;
     if (sb.stereo==1) len*=2;
     writedsp((len-1)&0xff); /* LOw */
     writedsp((((len-1)>>8)&0xff)); /* HIgh */
     if (sb.dspversion==0x200) writedsp(0x1C); /*normal speed (<23KHz) dma transfer. sb 1.5 (dsp version 2.00)*/
      else writedsp(0x90); /*high speed dma transfer, SB 2.0; dsp version 2.01 or higher*/
    }
   else
    {
/*     printf("playing 8bit single cycle to be exact.\n");
      if (sb.stereo==1) strcat(error,"[bug] stereo usage not possible in non-autoinit mode!\n");*/
     writedsp(0x14); /*8bit single cycle, dma dac*/
     writedsp((sb.dma_buf_size-1)&0xff); /* LOw */
     writedsp((((sb.dma_buf_size-1)>>8)&0xff)); /* HIgh */
    }
  }

 __asm__ __volatile__ ("sti");
 enable();
}

unsigned int get_dspversion()
{
 unsigned int tulos;
 __asm__ __volatile__ ("cli");
 disable();
 writedsp(0xE1);
 tulos=((unsigned int)readdsp())<<8;
 tulos+=readdsp();
 __asm__ __volatile__ ("sti");
 enable();
 return tulos;
}

inline volatile void singlecykleplayback(int from) /* gyyd spelling, ain't it?-) */
{ /* for comments, check out "playback()" above. */
 unsigned int page,offset;
 offset=(sb.dma_buf_segment<<4)+sb.dma_buf_offset+from;
 page=(sb.dma_buf_segment+((sb.dma_buf_offset+from)>>4))>>12;
/* __asm__ __volatile__ ("cli"); */ /* this only gets called from an */
 /* interrupt handler, in which ints are already disabled */
 outportb(sb.dmamaskport,sb.dstom);
 outportb(sb.dmaclrptrport,0);
 outportb(sb.dmamodeport,sb.dmode);
 outportb(sb.dmabaseaddrport,(offset&0xff));
 outportb(sb.dmabaseaddrport,((offset>>8)&0xff));
 outportb(sb.dmacountport,((sb.dmalen-1)&0xff));
 outportb(sb.dmacountport,(((sb.dmalen-1)>>8)&0xff));
 outportb(sb.pageport,page);
 outportb(sb.dmamaskport,sb.dstam);
 writedsp(0x14); /*8bit single cycle*/
 writedsp((sb.dma_buf_size-1)&0xff);
 writedsp((((sb.dma_buf_size-1)>>8)&0xff));
/* __asm__ __volatile__ ("sti"); */
}

/* end of sb.h */
#endif
