#ifndef _hmod_playing_h
#define _hmod_playing_h
/* playing.h, the tracking code */

static volatile void begin_of_playing(){}

void set_bpm(int bpm)
{
 if (bpm<46) bpm=46;
 if (bpm>256) bpm=256;
 play.bpm=bpm;
 kello.timspeed=1193181*5/(bpm*2); /* hz=2*bpm/5 */
 asm volatile(
 "pushfl
  cli");
 outportb(0x43,0x36);
 outportb(0x40,(kello.timspeed&0xFF));
 outportb(0x40,((kello.timspeed>>8)&0xFF));
 asm volatile("popfl");
}

void setamigafreq(unsigned int Achanna, unsigned int Aperiod)
{
 if (Aperiod>0) _output.set_freq(Achanna, (14317056L/Aperiod) );
/*  else set_freq(Achanna,8363); */
}

void do_vslide(int c)
{
 int i;
  if (channa[c].vslide==1)
   {
    i=(channa[c].volume+channa[c].effect.volumeslide_add);
    if (i<0) i=0; else
    if (i>64) i=64;
    channa[c].volume=i;
    _output.set_volume(c,i);
   }
}

void do_porta(int c,signed int amount)
{
 channa[c].period+=amount;
 if (channa[c].period<_minporta) channa[c].period=_minporta; else
 if (channa[c].period>_maxporta) channa[c].period=_maxporta;
 if ((channa[c].period==_minporta)||(channa[c].period==_maxporta))
  channa[c].whicheffect=_nothing;
 setamigafreq(c,channa[c].period);
}

void do_tremor(int c)
{
 int x=((channa[c].effect.tremor_para>>4)&0x0F);
 int y=(channa[c].effect.tremor_para&0x0F);
 channa[c].effect.tremor_count%=(x+y);
 if (channa[c].effect.tremor_count<x)
  _output.set_volume(c,channa[c].volume);
    else _output.set_volume(c,0);
 channa[c].effect.tremor_count++;
}

void update_effect()
{
 signed int vibe[32]=
  {
   0,24,49,74,97,120,141,161,180,197,212,224,235,244,250,253,
   255,253,250,244,235,224,212,197,180,161,141,120,97,74,49,24
  };
 int c,temp=0,d=0,w=0;

 for (c=1;c<=module.channels;c++)
 {
  do_vslide(c); /* slide the volume */
  switch (channa[c].whicheffect)
   {
    case _nothing:
     break;
    case _tremor:
     do_tremor(c);
     break;
    case _notecut:
     if (channa[c].effect.notecut_ontick==play.tick)
      {
       _output.set_volume(c,0);
       channa[c].volume=0;
       channa[c].whicheffect=_nothing;
      }
     break;

    case _retrignote:
     if ((play.tick%channa[c].effect.retrignote_ontick)==0)
      {
       switch (channa[c].effect.retrig_para&0xF0)
        { /* this is "beautiful", right?-) */
         case 0x00:break;
         case 0x10:channa[c].volume--;break;
         case 0x20:channa[c].volume-=2;break;
         case 0x30:channa[c].volume-=4;break;
         case 0x40:channa[c].volume-=8;break;
         case 0x50:channa[c].volume-=16;break;
         case 0x60:channa[c].volume=(channa[c].volume*2)/3; break;
         case 0x70:channa[c].volume/=2;break;
         case 0x80:break;
         case 0x90:channa[c].volume++;break;
         case 0xA0:channa[c].volume+=2;break;
         case 0xB0:channa[c].volume+=4;break;
         case 0xC0:channa[c].volume+=8;break;
         case 0xD0:channa[c].volume+=16;break;
         case 0xE0:channa[c].volume=(channa[c].volume*3)/2; break;
         case 0xF0:channa[c].volume*=2;
        }
       if (channa[c].volume>64) channa[c].volume=64; else
       if (channa[c].volume<0) channa[c].volume=0;
       _output.set_volume(c,channa[c].volume);
       _output.playsample(c,channa[c].effect.retrignote_sample,-2,-2,-2,
                    samples[channa[c].effect.retrignote_sample].offset);
      }
     break;

    case _portatonote: /*yuk. i suck, do i not?*/
     if (channa[c].effect.portanote_notetoportato>channa[c].effect.portanote_period)
     {
      channa[c].effect.portanote_period+=channa[c].effect.portanote_portaspeed;
      if (channa[c].effect.portanote_period>channa[c].effect.portanote_notetoportato)
       channa[c].effect.portanote_period=channa[c].effect.portanote_notetoportato;
      channa[c].period=channa[c].effect.portanote_period;
     } else
     if (channa[c].effect.portanote_notetoportato<channa[c].effect.portanote_period)
     {
      channa[c].effect.portanote_period-=channa[c].effect.portanote_portaspeed;
      if (channa[c].effect.portanote_period<channa[c].effect.portanote_notetoportato)
       channa[c].effect.portanote_period=channa[c].effect.portanote_notetoportato;
      channa[c].period=channa[c].effect.portanote_period;
     } else channa[c].whicheffect=_nothing;
     setamigafreq(c,channa[c].period);
     break; /*ya want some spaghetti? oh yes i do. ya want some spaghetti? oh yes i do.*/

    case _arpeggio:
     switch (play.tick%3)
     {
      case 0: w=periods[channa[c].effect.arpeggio_note]; break;
      case 1: w=periods[channa[c].effect.arpeggio_note+channa[c].effect.arpeggio_xfine]; break;
      case 2: w=periods[channa[c].effect.arpeggio_note+channa[c].effect.arpeggio_yfine]; break;
     }
     if (samples[channa[c].lastinstru].c2spd>0)
      setamigafreq(c,(8363L*w)/samples[channa[c].lastinstru].c2spd);
     break;

    case _porta:
     do_porta(c,channa[c].effect.porta_add);
     break;

    case _vibrato:
     temp=(channa[c].effect.vibrato_vibepos&31);
     switch (waveform.vibrato&3) {
      case 0: d=vibe[temp]; break; /*sine*/
      case 1: /*ramp down*/
       temp*=8;
       if (channa[c].effect.vibrato_vibepos<0) temp=255-temp;
       d=temp;
       break;
      case 2: d=255; break; /*square ramp*/
      case 3: /*"random"*/
       d=vibe[temp];
       break;
     }
     d=(d*channa[c].effect.vibrato_depth)/128;
     if (channa[c].effect.vibrato_vibepos<0)
      setamigafreq(c,channa[c].period-d);
       else setamigafreq(c,channa[c].period+d);
     channa[c].effect.vibrato_vibepos+=channa[c].effect.vibrato_speed;
     if (channa[c].effect.vibrato_vibepos>31) channa[c].effect.vibrato_vibepos-=64;
     break;

    case _tremolo:
     temp=(channa[c].effect.tremolo_vibepos&31);
     switch (waveform.tremolo) {
      case 0:d=vibe[temp]; break;
      case 1:temp*=8; if (channa[c].effect.tremolo_vibepos<0) temp=255-temp;
             d=temp; break;
      case 2:d=255; break;
      case 3:d=vibe[temp]; break;
     }
     d=(d*channa[c].effect.tremolo_depth)/64;
     if (channa[c].effect.tremolo_vibepos<0)
      d=channa[c].volume-d; else d=channa[c].volume+d;
     if (d<0) d=0; else if (d>64) d=64;
     _output.set_volume(c,d);
     channa[c].effect.tremolo_vibepos+=channa[c].effect.tremolo_speed;
     if (channa[c].effect.tremolo_vibepos>31) channa[c].effect.tremolo_vibepos-=64;
     break;
   }
 }
 return;
}

void setupvslide(int cha, unsigned char efpara)
{
 if ( (((efpara>>4)==0)||((efpara&0x0F)==0)) && (efpara!=0) ) /*nice.*/
  { /*check that efpara is not 0, but that the other of the n(y/i)bbles is.*/
   if ((efpara>>4)>0) channa[cha].effect.volumeslide_add=(efpara>>4); else
   if ((efpara&0x0F)>0) channa[cha].effect.volumeslide_add=-(int)(efpara&0x0F);
   channa[cha].vslide=1; /*true*/
  }
}

void update_row()
{
 int pat,roffs,rc,j;
 struct
  {
   unsigned char note;
   unsigned char samp;
   unsigned char effe;
   unsigned char epar;
   unsigned char volu;
  } row={0,0,0,0,0};

  void hoida_effyt(int rc) /* handle the effects */
   {
    channa[rc].effy=row.effe;
    switch (row.effe) {
     case 0x11: /*s3m "D", volumeslide. written separately so that D00 would use the last paras */
      if (row.epar!=0) channa[rc].effect.s3m_vslide_para=row.epar;
       else row.epar=channa[rc].effect.s3m_vslide_para;
      if ((row.epar&0x0F)==0x0F) channa[rc].volume+=((row.epar>>4)&0xF);
       else
      if ((row.epar&0xF0)==0xF0) channa[rc].volume-=(row.epar&0x0F);
       else
        {
         setupvslide(rc,row.epar);
         if (module.fast_vslides==1) do_vslide(rc);
        }
      break;
     case 0x12: /*s3m "E", portamento down*/
      if (row.epar!=0) channa[rc].effect.s3m_porta_down=row.epar;
      switch (channa[rc].effect.s3m_porta_down&0xF0)
      {
       case 0xF0: /*fine slide*/
        do_porta(rc,4*((int)channa[rc].effect.s3m_porta_down&0x0F));
        break;
       case 0xE0: /*extra fine slide*/
        do_porta(rc,((int)channa[rc].effect.s3m_porta_down&0x0F));
        break;
       case 0x00: break;
       default: /* normal slide */
        channa[rc].whicheffect=_porta;
        channa[rc].effect.porta_add=((signed int)row.epar)*4;
        break;
      }
      break;
     case 0x13: /*s3m "F", portamento up*/
      if (row.epar!=0) channa[rc].effect.s3m_porta_down=row.epar;
      switch (channa[rc].effect.s3m_porta_down&0xF0)
      {
       case 0xF0: /* fine slide */
        do_porta(rc,(-4)*((int)channa[rc].effect.s3m_porta_down&0x0F));
        break;
       case 0xE0: /* extra fine slide */
        do_porta(rc,-((int)channa[rc].effect.s3m_porta_down&0x0F));
        break;
       case 0x00: break; /* normal slide */
       default:
        channa[rc].whicheffect=_porta;
        channa[rc].effect.porta_add=(-4)*((signed int)row.epar);
        break;
      }
      break;
     case 0x14: /*s3m "I", tremor*/
      if (row.epar!=0) channa[rc].effect.tremor_para=row.epar;
      channa[rc].whicheffect=_tremor;
      do_tremor(rc);
      break;
     case 0x15: /*retrig with volume slide support*/
      if ((row.note!=_nothing)&&(row.samp<module.maxsamples))
       {
        if (row.epar>0) channa[rc].effect.retrig_para=row.epar;
         else row.epar=channa[rc].effect.retrig_para;
        channa[rc].whicheffect=_retrignote;
        channa[rc].effect.retrignote_sample=row.samp;
        channa[rc].effect.retrignote_ontick=(row.epar&0x0F);
       }
      break;
     case 0x16: /*fine vibrato*/
      channa[rc].whicheffect=_vibrato;
      if ((row.epar&0xF0)>0) channa[rc].effect.vibrato_speed=(row.epar>>4);
      if ((row.epar&0x0F)>0) channa[rc].effect.vibrato_depth=(int)(row.epar&0x0F);
      break;
     case 0x17: /*set global volume*/
      mastervolume(row.epar);
      break;
     case 0x08: /*set pan*/
      channa[rc].pan=row.epar;
      _output.set_pan(rc,channa[rc].pan);
      break;
     case 0x0C: /*set volume*/
      if (row.epar>0x40) row.epar=0x40;
      channa[rc].volume=row.epar;
      break;
     case 0x0F: /*set speed*/
/*      if (row.epar<0x20) play.speed=row.epar; else set_bpm(row.epar);*/
      play.speed=row.epar;
      break;
     case 0x10: /*set bpm*/
      set_bpm(row.epar);
      break;
     case 0x09: /*set sample offset*/
      if (channa[rc].lastinstru<module.maxsamples)
       {
        if (row.epar>0) channa[rc].lastsampleoffset=row.epar;
        j=((unsigned int)channa[rc].lastsampleoffset)<<8;
        if (j>=samples[channa[rc].lastinstru].length)
         j=samples[channa[rc].lastinstru].length-1;
        samples[channa[rc].lastinstru].offset=j;
       }
      break;
     case 0x0B: /*jump to pattern*/
      play.patternjump=1;
      row.epar++;
      if (row.epar>song.length) row.epar=1;
      play.order=row.epar;
      play.row=0;
      break;
     case 0x0D: /*pattern break*/
      row.epar=(row.epar>>4)*10+(row.epar&0x0F)+1;
      if (row.epar>=65) row.epar=1;
      play.row=row.epar-1;
      if ((play.patternjump==0)&&(play.patternbreak==0)) play.order++;
      if (play.order>song.length) play.order=1;
      play.patternbreak=1;
      break;
     case 0x0E: /*.mod extended commands.*/
      switch ((unsigned int)row.epar>>4) {
       case 0x0C: /* note cut / cut note */
        channa[rc].effect.notecut_ontick=row.epar&0x0F;
        if ((row.epar&0x0F)>0) channa[rc].whicheffect=_notecut;
        break;
/*       case 0x09: this is included in the effect 0x15
        if ((row.note!=_nothing)&&(row.samp<module.maxsamples))
         {
          if ((row.epar&0x0F)>0) channa[rc].effect.retrig_para=row.epar;
           else row.epar=channa[rc].effect.retrig_para;
          channa[rc].whicheffect=_retrignote;
          channa[rc].effect.retrignote_sample=row.samp;
          channa[rc].effect.retrignote_ontick=(row.epar&0x0F);
         }
        break;*/
       case 0x04: /*set vibrato waveform*/
        waveform.vibrato=(row.epar&0x0F)&3;
        if ((row.epar&0x0F)>=4) waveform.retrigvib=0;
         else waveform.retrigvib=1;
        break;
       case 0x07: /*set tremolo waveform*/
        waveform.tremolo=(row.epar&0x0F)&3;
        if ((row.epar&0x0F)>=4) waveform.retrigtre=0;
         else waveform.retrigtre=1;
        break;
       case 0x05: /*set finetune*/
        samples[channa[rc].lastinstru].c2spd=finetunes[row.epar&0x0F];
        break;
       case 0x06: /*pattern loop*/
        if ((row.epar&0x0F)==0) channa[rc].pattern_loop_row=play.row;
         else
          {
           if (channa[rc].pattern_loop_loop==0) channa[rc].pattern_loop_loop=(row.epar&0x0F);
            else channa[rc].pattern_loop_loop--;
           if (channa[rc].pattern_loop_loop>0) play.row=channa[rc].pattern_loop_row-1;
          }
        break;
       case 0x0A: /*fine volume slide up*/
        channa[rc].volume+=(row.epar&0x0F);
        break;
       case 0x0B: /*fine volume slide down*/
        channa[rc].volume-=(row.epar&0x0F);
        break;
       case 0x0E: /*pattern delay*/
        play.patterndelay=row.epar&0x0F;
        break;
       case 0x08: /*16 position pan*/
        channa[rc].pan=(row.epar&0x0F)*16+7;
        _output.set_pan(rc,channa[rc].pan);
        break;
       default:
        break;
      }
      break;
     case 0x03: /*porta to note / tone portamento*/
      channa[rc].whicheffect=_portatonote;
      if (row.epar>0) channa[rc].effect.portanote_portaspeed=
       ((row.epar>>4)*10+(row.epar&0x0F))*4;
      channa[rc].effect.portanote_period=channa[rc].period;
      if (samples[channa[rc].lastinstru].c2spd>0)
       channa[rc].effect.portanote_notetoportato=
        (8363L*periods[channa[rc].lastnote])/samples[channa[rc].lastinstru].c2spd;
      break;

      /* volume slide,porta+volume slide,vibrato+volume slide*/
/*     case 0x0A:setupvslide(rc,row.epar); break; */
     case 0x05:setupvslide(rc,row.epar); break;
     case 0x06:setupvslide(rc,row.epar); break; /*doesn't affect sample's triggering*/

     case 0x00: /*arpeggio*/
      if (channa[rc].lastnote!=_nothing)
       {
        channa[rc].whicheffect=_arpeggio;
        channa[rc].effect.arpeggio_note=channa[rc].lastnote;
        channa[rc].effect.arpeggio_xfine=(row.epar>>4);
        channa[rc].effect.arpeggio_yfine=(row.epar&0x0F);
       }
      break;
     case 0x01: /*porta up*/
      channa[rc].whicheffect=_porta;
      channa[rc].effect.porta_add=-((signed int)row.epar)*4;
      break;
     case 0x02: /*porta down*/
      channa[rc].whicheffect=_porta;
      channa[rc].effect.porta_add=((signed int)row.epar)*4;
      break;
     case 0x04: /*vibrato*/
      channa[rc].whicheffect=_vibrato;
      if ((row.epar&0xF0)>0) channa[rc].effect.vibrato_speed=(row.epar>>4);
      if ((row.epar&0x0F)>0) channa[rc].effect.vibrato_depth=(int)(row.epar&0x0F)*4;
      break;
     case 0x07: /*tremolo*/
      channa[rc].whicheffect=_tremolo;
      if ((row.epar&0xF0)>0) channa[rc].effect.tremolo_speed=(row.epar>>4);
      if ((row.epar&0x0F)>0) channa[rc].effect.tremolo_depth=(row.epar&0x0F);
      break;
     default:
      break;
    }
    return;
   } /*end of hoida_effyt*/

 pat=song.order[play.order];
 play.physpatta=pat;
 if (pat>song.patterns) return;
 roffs=(play.row-1)*module.channels*5;
 play.patternjump=0; play.patternbreak=0;
 for (rc=1;rc<=module.channels;rc++) {
  roffs+=5;

  row.samp=song.pattern[pat][roffs+0]; /*get sample*/
  row.note=song.pattern[pat][roffs+1]; /*get note*/
  row.effe=song.pattern[pat][roffs+2]; /*get effect*/
  row.epar=song.pattern[pat][roffs+3]; /*get effect parameter*/
  row.volu=song.pattern[pat][roffs+4]; /*get volume*/

  if (row.volu!=_nothing) channa[rc].volume=row.volu;
  /* set the volume even if there is no sample or note */

  if (row.samp<module.maxsamples)
   {
    channa[rc].lastinstru=row.samp;
    if (row.volu==_nothing) channa[rc].volume=samples[row.samp].volume;
     else channa[rc].volume=row.volu;
   }
  if ((row.note!=_nothing)&&(row.note!=_keyoff))
   {
    if (waveform.retrigvib==1) channa[rc].effect.vibrato_vibepos=0;
    if (waveform.retrigtre==1) channa[rc].effect.tremolo_vibepos=0;

    if ((row.effe!=0x03)&&(row.effe!=0x05)&&(samples[channa[rc].lastinstru].c2spd>0))
     channa[rc].period=(8363L*periods[row.note])/samples[channa[rc].lastinstru].c2spd;

    channa[rc].lastnote=row.note;

   } else if (row.note==_keyoff) _output.stopchannel(rc);

  channa[rc].note=row.note;
  channa[rc].effy=_nothing;
  if (row.samp<module.maxsamples) channa[rc].instru=row.samp;

  channa[rc].vslide=0; /* volume slide off */
  if ((row.effe!=0x05)&&(row.effe!=0x06))
   channa[rc].whicheffect=_nothing;
  /* if there is a combined effect (vib+vslid,port+vslid,etc) */
  /* then do not stop the first effect (vib,port)             */

  if (channa[rc].lastinstru<module.maxsamples)
   samples[channa[rc].lastinstru].offset=0;

  if ((row.effe!=0)||(row.epar!=0)) hoida_effyt(rc);

  if (channa[rc].volume<0) channa[rc].volume=0;
   else if (channa[rc].volume>64) channa[rc].volume=64;

  _output.set_volume(rc,channa[rc].volume);
  _output.set_pan(rc,channa[rc].pan);

  if (channa[rc].period>0) setamigafreq(rc,channa[rc].period);

  if ( (row.note!=_nothing)&&(row.note!=_keyoff)&&(channa[rc].lastinstru<module.maxsamples)&&
       (row.effe!=0x03)&&(row.effe!=0x05) )
   _output.playsample(rc,channa[rc].lastinstru,-2,-2,-2,samples[channa[rc].lastinstru].offset);

 }
}

void do_play()
{
 play.tick++;
 if (play.tick>=play.speed)
  {
   play.tick=0;
   if (play.patterndelay==0)
    {
     update_row();
     play.row++;
     if (play.row>64)
      {
       play.row=1;
       play.order++;
       if (play.order>song.length)
        {
         play.order=1;
         play.row=1;
         play.speed=song.speed;
         play.bpm=song.bpm;
         play.patterndelay=0;
         waveform.retrigvib=1;
         waveform.retrigtre=1;
         waveform.vibrato=0;
         waveform.tremolo=0;
         set_bpm(play.bpm);
        }
      }
    } else play.patterndelay--;
  } else update_effect();
}

static volatile void modplay()
{
 do_play(); /* update module */

 kello.counter+=kello.timspeed;
 if (kello.counter>65535) /* the old int must be called */
 { /* 1193181/65536(=~18.2) times per second*/
  kello.counter-=65536;
  /*push flags on stack because the old interrupt handler will*/
  /*pop 'em. then we'll do a far call (long call) to the old handler*/
  asm volatile (
  "pushfl
   lcall %0
  "
  :
  :"g" (kello.call_me));
 }
  else
   outportb(0x20,0x20); /*ack*/

 asm volatile ("sti");
}

static volatile void end_of_playing(){}

void deinit_playing()
{
 asm volatile ("cli");
 disable();
 outportb(0x43,0x36);
 outportb(0x40,0);
 outportb(0x40,0);
 _go32_dpmi_set_protected_mode_interrupt_vector(8,&kello.vanha);
 asm volatile ("sti");
 enable();
}

void init_playing()
{
 int i;

 _go32_dpmi_lock_code(begin_of_playing,((char *)end_of_playing-(char *)begin_of_playing));

 play.speed=song.speed;
 play.bpm=song.bpm;
 play.tick=play.speed;
 play.order=1;
 play.row=1;
 play.patterndelay=0;
 play.patternbreak=0;
 play.patternjump=0;

 for (i=1; i<33; i++)
  {
   channa[i].lastinstru=_nothing;
   channa[i].lastnote=_nothing;
   channa[i].whicheffect=_nothing;
   channa[i].period=1712;
   channa[i].vslide=0;
   channa[i].pattern_loop_row=0;
   channa[i].lastsampleoffset=0;
   memset(&channa[i].effect,0,sizeof(modplay_effectrec));
   channel[i].freq=8363;
  }
 waveform.retrigvib=1;
 waveform.retrigtre=1;
 waveform.vibrato=0;
 waveform.tremolo=0;

 for (i=0;i<module.maxsamples;i++) samples[i].offset=0;

 if (atexit(deinit_playing)!=0) strcat(error,"auto clean-up not inited.\n");
 kello.counter=0;
 i=0;
 asm volatile ("cli");
 disable();

 i+=_go32_dpmi_get_protected_mode_interrupt_vector(8,&kello.vanha);
 /*vanhan keskeytysksittelijn osoite talteen.*/

 kello.call_me=(iso)kello.vanha.pm_offset+ /*first 32 bits are the offset*/
  ( ((iso)kello.vanha.pm_selector)<<32 ); /* and the last 16 selector..?*/

 kello._info.pm_offset=(unsigned long int)modplay;
 kello._info.pm_selector=_my_cs();
 disable();
 i+=_go32_dpmi_allocate_iret_wrapper(&kello._info);
 i+=_go32_dpmi_set_protected_mode_interrupt_vector(8,&kello._info);
 /* i strongly recommend that your extender does not remap ints */

 set_bpm(play.bpm);
 asm volatile ("sti");
 enable();
 if (i!=0) strcat(error,"error initializing playing.\n");
}

/* end of playing.h */
#endif

