#ifndef _hmod_mixmode_h
#define _hmod_mixmode_h
/*mixmode.h*/

#include "vali.h" /* the selection bar */

typedef struct
{
 char name[70];
 int allow_auto_init;
 int allow_16bit;
 int allow_stereo;
 int mindsp,maxdsp;
} mixingmode_t;

mixingmode_t mixingmodes[7]=
{
 {"SB 1.0,  8 bits, mono,   max 22 kHz, irq controlled dma",0,0,0,0x000,0xFFFF},
 {"SB 1.5+, 8 bits, mono,   max 44(SB2.0+) / 22(SB1.5) kHz",1,0,0,0x200,0xFFFF},
 {"SB pro,  8 bits, stereo, max 22 kHz, does it work? no? ",1,0,1,0x300,0x0400},
 {"SB 16,   8 bits, stereo, max 45 kHz                    ",1,0,1,0x401,0xFFFF},
 {"SB 16,  16 bits, mono,   max 45 kHz (faster than 8 bit)",1,1,0,0x401,0xFFFF},
 {"SB 16,  16 bits, stereo, max 45 kHz (faster than 8 bit)",1,1,1,0x401,0xFFFF},
 {"The best mode available                                ",1,1,1,0x000,0xFFFF}
};

int choose_mixing_mode(unsigned short dsp) /*-1 aborted, else the chosen one*/
{
 vali_t mmodes[7];
 int i;
 for (i=0;i<7;i++)
  {
   strcpy(mmodes[i].menutext,mixingmodes[i].name);
   if ( (dsp>=mixingmodes[i].mindsp) && (dsp<=mixingmodes[i].maxdsp) ) mmodes[i].selectable=1;
    else mmodes[i].selectable=0;
  }
 if ((sb.hdma<4)||(sb.hdma>7)) {mmodes[4].selectable=0; mmodes[5].selectable=0;}
 return valintabar(mmodes,7," Select ",7);
}

typedef struct
{
 char name[70];
 unsigned int speedhz;
} mixingspeed_t;

mixingspeed_t mixingspeeds[7]=
{
 {" 5 kHz, very fast :)",5000},
 {"11 kHz, can't describe it",11111},
 {"16 kHz, extra low quality",16130},
 {"22 kHz, low quality",21739},
 {"29 kHz, medium quality",29412},
 {"37 kHz, normal quality",37038},
 {"The highest kHz available",45454}
};

int select_speed(unsigned int max)
{
 vali_t speedos[7];
 unsigned int i;
 signed int r;
 for (i=0;i<7;i++)
  {
   strcpy(speedos[i].menutext,mixingspeeds[i].name);
   if (mixingspeeds[i].speedhz<=max) speedos[i].selectable=1;
    else speedos[i].selectable=0;
  }
 speedos[6].selectable=1; /* viimoinen on aina valittavissa. ks yls. */
 r=valintabar(speedos,7," Select ",7);
 switch (r)
  {
   case -1:i=max;break;
   default:
    i=mixingspeeds[r].speedhz;
    break;
  }
 if (i>max) i=max;
 return i;
}

/* end of mixmode.h */
#endif
