#ifndef _hmod_sbdev_h
#define _hmod_sbdev_h

/* sbdev.h, the sound blaster device */

#define DEFAULT_AMPLIFICATION 259

struct
{
 int koee; /* sb's status, actually no point for it to be here. */
 int vuoro; /* double buffer */
 unsigned int amplification,active_channels;
} mixerinfo;

signed int mtmp[5120]; /* 32-bit tmp buffer for mixing */
signed int *voltable; /* volume table for mixing */

#include "sb.h" /*sb's hardware stuff.*/
#include "mixmode.h" /*the selection bar of the mixing mode.*/

static volatile void bom(){} /*begin of mixer-stuff*/

/* lock these! */
 signed int mi,sam,monovol,rightvol,leftvol,*rtaul,*ltaul,ma,*taul,*vali;
 unsigned short selektoori;
 unsigned long long bytes,bytez,fadd;
 unsigned char *deita;
 unsigned int pit,faddl,faddh,posil,posih;

 extern inline volatile void mixmonoloop();
 extern inline volatile void mixstereoloop();
 extern inline volatile void clip16bitloop();
 extern inline volatile void clip8bitloop();

void mixmono() /*mono mixer*/
{

 vali=mtmp;
 for (mi=0;mi<33;mi++) if (channel[mi].playing==1)
  {
   ma=0;
   fadd=(((iso)channel[mi].freq)<<32)/(iso)sb.playspeed; /* calc. step */
   sam=channel[mi].sample;
   if ((samples[sam].used!=1)||(samples[sam].data==NULL)||(channel[mi].freq==0)) channel[mi].playing=0;
    /* make sure that we're not playing a NULL sample */

   monovol=(channel[mi].volume*master*4)&0xFFFFFF00;

   if (monovol>0x4000) monovol=0x4000; /* force 64 to be the max. volume */

   taul=voltable;
   taul+=monovol; /* djgpp adds monovol*4 (as it should) */
   deita=samples[sam].data;
   while ((ma<sb.dma_buf_size)&&(channel[mi].playing==1))
    {
     bytes=((iso)samples[sam].length<<32);
     bytez=((iso)samples[sam].loop_endi<<32);
     if ((samples[sam].loop_endi>0)&&(bytez<bytes)) bytes=bytez;
/*
     bytez=(((iso)(sb.dma_buf_size-ma))*fadd)+channel[mi].position;
     if (bytez<bytes) bytes=bytez;
     while (channel[mi].position<bytes) {
       vali[ma]+=taul[ deita[channel[mi].position>>32] ];
       channel[mi].position+=fadd;
       ma++;
      }
*/
//     pit=(bytes-channel[mi].position)/fadd;
     bytez=bytes-channel[mi].position;
     pit=bytez/fadd;

     while ( ( (iso)pit * (iso)fadd ) >= bytez ) pit--; /* krsh prtektin */
     while ( ( (iso)pit * (iso)fadd ) < bytez ) pit++;

     if (pit>(sb.dma_buf_size-ma)) pit=(sb.dma_buf_size-ma);
     faddl=(fadd&0xFFFFFFFF);
     faddh=((fadd>>32)&0xFFFFFFFF);
     posil=(channel[mi].position&0xFFFFFFFF);
     posih=((channel[mi].position>>32)&0xFFFFFFFF);

     mixmonoloop(); /* mix! */

/*     channel[mi].position=bytes; */
     channel[mi].position=(iso)posil+(((iso)posih)<<32);
     ma+=pit;

     if ( (samples[sam].loop_endi>0) && (channel[mi].position>=(((iso)samples[sam].loop_endi<<32)-2147483647)) )
      channel[mi].position=((iso)samples[sam].loop_start<<32);

     if (channel[mi].position>= (((iso)samples[sam].length<<32)-2147483647) )
      channel[mi].playing=0; /*stop channel*/
    }
   }
}

void mixstereo() /*stereo mixer*/
{
/*
 signed int mi,sam,rightvol,leftvol,*rtaul,*ltaul,ma,*vali;
 unsigned long long bytes,bytez,fadd;
 unsigned char *deita,daatta;
*/

 vali=mtmp;
 for (mi=0;mi<33;mi++) if (channel[mi].playing==1)
  {
   ma=0;
   fadd=(((iso)channel[mi].freq)<<32)/(iso)sb.playspeed;
   sam=channel[mi].sample;
   if ((samples[sam].used!=1)||(samples[sam].data==NULL)) channel[mi].playing=0;

   leftvol=((master*channel[mi].volume*(256-channel[mi].pan))>>6)&0xFFFFFF00;
   if (leftvol>0x4000) leftvol=0x4000; /*force 64 to be the maximum volume*/
   rightvol=((channel[mi].volume*channel[mi].pan*master)>>6)&0xFFFFFF00;
   if (rightvol>0x4000) rightvol=0x4000;

   rtaul=voltable; /*make rtaul point to the volumetable*/
   ltaul=voltable;
   rtaul+=rightvol; /* and then add the correct volume position */
   ltaul+=leftvol;
   deita=samples[sam].data;
   while ((ma<sb.dma_buf_size*2)&&(channel[mi].playing==1))
    {
     bytes=((iso)samples[sam].length<<32);
     bytez=((iso)samples[sam].loop_endi<<32);
     if ((samples[sam].loop_endi>0)&&(bytez<bytes)) bytes=bytez;
/*
     bytez=(((iso)(sb.dma_buf_size-ma/2))*fadd)+channel[mi].position;
     if (bytez<bytes) bytes=bytez;
     while (channel[mi].position<bytes) {
       daatta=deita[channel[mi].position>>32];
       vali[ma]+=ltaul[daatta];
       vali[ma+1]+=rtaul[daatta];
       channel[mi].position+=fadd;
       ma+=2;
      }
*/

/*     pit=(bytes-channel[mi].position)/fadd; */

     bytez=bytes-channel[mi].position;
     pit=bytez/fadd;
     while ( ( (iso)pit * (iso)fadd ) >= bytez ) pit--;
     while ( ( (iso)pit * (iso)fadd ) < bytez ) pit++;

     if (pit>(sb.dma_buf_size-ma/2)) pit=(sb.dma_buf_size-ma/2);

     faddl=(fadd&0xFFFFFFFF);
     faddh=((fadd>>32)&0xFFFFFFFF);
     posil=(channel[mi].position&0xFFFFFFFF);
     posih=((channel[mi].position>>32)&0xFFFFFFFF);

     mixstereoloop(); /* mix! */

/*     channel[mi].position=bytes; */
     channel[mi].position=(iso)posil+(((iso)posih)<<32);
     ma+=pit*2;

     if ( (samples[sam].loop_endi>0) && (channel[mi].position>=(((iso)samples[sam].loop_endi<<32)-2147483647)) )
      channel[mi].position=((iso)samples[sam].loop_start<<32);

     if (channel[mi].position>= (((iso)samples[sam].length<<32)-2147483647) )
      channel[mi].playing=0; /*stop channel*/
    }
   }
}

static void keskeytys() /*mixer*/
{
 signed int outputsamples,i/*,mi,ma*/;
 mixerinfo.koee=inportb(sb.ackport); /*sb ack*/

 if (sb.autoinit==0)
  {
   singlecykleplayback(mixerinfo.vuoro); /*restart dma transfer*/
   if (mixerinfo.vuoro==0) mixerinfo.vuoro=sb.dma_buf_size;
    else mixerinfo.vuoro=0;
  }

 for (i=0;i<4096;i++) mtmp[i]=0; /* clear mixing buffer */
 /*there would be a faster way of doing this, but this'll do */

 if (sb.stereo==0) mixmono(); /* do mixing */
  else mixstereo();

 outputsamples=sb.dma_buf_size;
 if (sb.stereo==1) outputsamples*=2;

 if (sb._16bit==0) /*output: 8 bits*/
  {
/*
   _farsetsel(sb.dma_buf_selector);
   for (i=mixerinfo.vuoro;i<mixerinfo.vuoro+outputsamples;i++) //clip'n'move to dma_buffer
   {
    (signed)mi=(signed)mtmp[i-mixerinfo.vuoro]>>8;  //peek from the 32-bit mixing buffer
    if (mi<(-128)) mi=-128; else if (mi>127) mi=127;//clip
    (unsigned char)mi^=0x80; // convert to unsigned
    _farnspokeb(sb.dma_buf_offset+i,(unsigned char)mi); // poke to dma_buffer
   }
*/
   selektoori=sb.dma_buf_selector;
   pit=outputsamples;
   vali=mtmp;
   posil=sb.dma_buf_offset+mixerinfo.vuoro;
   clip8bitloop(); /* sar'n'clip'n'move to dma_buffer */
  }
 else if (sb._16bit==1) /*output: 16 bits*/
  {
/*
   _farsetsel(sb.dma_buf_selector);
   i=0;
   ma=sb.dma_buf_offset+mixerinfo.vuoro*2;
   while(i<outputsamples) //clip'n'move to dma_buffer
   {
    (signed)mi=(signed)mtmp[i];
    if (mi<(-32768)) mi=(-32768); else if (mi>32767) mi=32767; //clip
    _farnspokew(ma,mi); //poke to dma_buffer
    ma+=2;
    i++;
   }
*/
   selektoori=sb.dma_buf_selector;
   pit=outputsamples;
   vali=mtmp;
   posil=sb.dma_buf_offset+mixerinfo.vuoro*2;
   clip16bitloop(); /* clip'n'move to dma_buffer */
  }

 if (sb.autoinit==1) /*doublebuffer*/
 {
  if (mixerinfo.vuoro==0) mixerinfo.vuoro=sb.dma_buf_size;
   else mixerinfo.vuoro=0; /*toggle it*/
  if (sb.stereo==1) mixerinfo.vuoro*=2;
 }

 sb.interrupts++;

 if (sb.irq>7) outportb(0xA0,0x20);  /* pic2 eoi */
 outportb(0x20,0x20);                /* "end of interrupt" */
 asm volatile("sti");
}

static volatile void eom(){} /*end of mixer-stuff*/

#include "sbstaff.h"

void set_amplification(signed int level)
{
 signed int b,c;

 if (level<33) level=33; else
  if (level>16384) level=16384;

 mixerinfo.amplification=level;

 level-=mixerinfo.active_channels; /* useless, but it's there :) */

 if (sb.stereo==1) level=(level*5)/4;

 for (b=0;b<65;b++) /* calculate the volume table*/
  for (c=0;c<256;c++)
   {
#define isoh signed long long
    voltable[(b<<8)|c]=((isoh)level*(isoh)b*(isoh)(c-128))/256;
   }
}

void sb_set_channels(int __channels)
{
 if (__channels>32) __channels=32; else
 if (__channels<1) __channels=1;
 mixerinfo.active_channels=__channels;
 set_amplification(mixerinfo.amplification);
}

int sb_get_channels()
{
 return mixerinfo.active_channels;
}

static int sb_init(int askuser)
/*IN: 1 yes, do ask; 0 no, don't ask
 OUT: 0 successful, -1 failed. */
{
 printf("\n- sbdev v0.94a by Chem/Hubris. -\n");

 voltable=(signed int*)malloc(16640*4);
 if (voltable==NULL)
  {
   strcat(error,"out of memory.\n");
   return -1;
  }

 mixerinfo.active_channels=32;
 set_amplification(DEFAULT_AMPLIFICATION);
 sb_set_channels(32);

 _go32_dpmi_lock_code(bom,((char *)eom-(char *)bom));

 if (soundblaster_init(askuser)!=0)
  {
   if (voltable!=NULL) free(voltable);
   strcat(error,"sb initialization failed.\n");
   return -1;
  }

 _go32_dpmi_lock_data(&mixerinfo,sizeof(mixerinfo));
 _go32_dpmi_lock_data(&samples[0],sizeof(samrec)*102);
 _go32_dpmi_lock_data(&channel[0],sizeof(channelinforec)*33);
 _go32_dpmi_lock_data(voltable,16640*4);
 _go32_dpmi_lock_data(&mtmp,5120);

 printf("sb at A%Xh I%d D%d",sb.base,sb.irq,sb.dma);
 if (sb._16bit==1) printf(" H%d",sb.hdma);
 printf(", output: ");
 if (sb._16bit==1) printf("16 bits, "); else printf("8 bits, ");
 if (sb.stereo==1) printf("stereo, "); else printf("mono, ");
 printf("%d Hz, ",sb.playspeed);
 if (sb.autoinit==1) printf("autoinit dma.\n"); else
  printf("irq controlled dma.\n");

// dspcopyright();
 printf("dsp version: %d.",(unsigned char)(sb.dspversion>>8)&0xff);
 if ((sb.dspversion&0xff)<10) printf("0");
 printf("%d ",(unsigned char)(sb.dspversion&0xff));
 if (sb.dspversion<0x200) printf("(SB 1.0)\n"); else
 if (sb.dspversion==0x200) printf("(SB 1.5)\n"); else
 if (sb.dspversion<0x300) printf("(SB 2.0)\n"); else
 if (sb.dspversion<0x401) printf("(SB pro)\n"); else
 if (sb.dspversion>0x400) printf("(SB 16)\n");
 sb_set_channels(32);
 mastervolume(64);

 return 0;
}
/* end of sbdev.h */
#endif
