#ifndef _hmod_mod_h
#define _hmod_mod_h
/* mod.h, .mod loader. */

#include "mod_det.h" /* check_mk() */

/*
int load_mod(char *name)
IN:
 filename
OUT:
 0 successful
 -1 failed
DESCRIPTION:
 Loads 31 instrument 1-32 channel protracker/fast tracker 1
 compatible modules.
*/

int load_mod(char *name)
{
 FILE *f;
 char sig[5];
 int ii;

 void getname()
 {
  char str[20];
  fseek(f,0+module.file_offset,SEEK_SET);
  fread(str,1,20,f);
  str[20]=0;
  strcpy(module.title,str);
 }

 unsigned short amigaword(unsigned short w)
 { /*"xchg lo.byte,hi.byte"*/
  return ( ((w&0xFF)<<8) + ((w>>8)&0xFF) );
 }

 int getsampleinfo() /* 0 successful */
 {
  int i;
  unsigned short w;
  unsigned char b;

  fseek(f,20+module.file_offset,SEEK_SET);
  totalsamples=0;
  for (i=1;i<=module.instruments;i++)
  {
   fread(samples[i].name,1,22,f);
   samples[i].name[23]=0;
   fread(&w,2,1,f);
   samples[i].length=2*((int)amigaword(w));
   totalsamples+=samples[i].length;
   fread(&b,1,1,f);
   if (b<16) samples[i].c2spd=finetunes[b]; else samples[i].c2spd=8363;
   fread(&b,1,1,f);
   samples[i].volume=((int)b);
   fread(&w,2,1,f);
   samples[i].loop_start=2*((int)amigaword(w));
   fread(&w,2,1,f);
   samples[i].loop_length=2*((int)amigaword(w));
   if (samples[i].loop_length<3) {samples[i].loop_length=0; samples[i].loop_start=0;}
    /*some modules have loops with length 1 or 2,*/
    /*which means no loop at all.*/
   samples[i].loop_endi=samples[i].loop_start+samples[i].loop_length;
   samples[i].used=(samples[i].length!=0);
  }
  gpoke.total=totalsamples+(module.instruments*99)+module.sample_space+256;
  /* leave "some" extra space, it is REQUIRED */

  return 0;
 }

 int loadpatterns() /* 0 successful */
 {
  unsigned int i,a;
  unsigned char b0,b1,b2,b3,ef,efpar;
  unsigned char *p;
  unsigned int offs;
  unsigned int periodfreq;

  unsigned char getnote(unsigned int __amigaval)
  { /*seek through the period table and return the correct index*/
   unsigned char c2;
   for (c2=0;c2<108;c2++)
    if (__amigaval>=periods[(c2+24)]) return c2;
   return _nothing;
  }

  printf("reading patterns..\n");
  p=(char *)malloc(64*module.channels*4);
  for (i=0;i<=song.patterns;i++)
   {
    song.pattern[i]=(char *)malloc(5*64*module.channels+10);
    fread(p,1,64*(unsigned int)module.channels*4,f);
    offs=0;
    for (a=1;a<=(64*(unsigned int)module.channels);a++)
     {
      b0=p[offs];
      b1=p[offs+1];
      b2=p[offs+2];
      b3=p[offs+3];
      offs+=4;

      song.pattern[i][a*5]=(b0&0xF0)+(b2>>4);
      if ((song.pattern[i][a*5]==0)||(song.pattern[i][a*5]>31))
       song.pattern[i][a*5]=_nothing;
      periodfreq=(((unsigned int)(b0&0x0F))<<8)+(unsigned int)b1;
      song.pattern[i][a*5+1]=getnote(periodfreq);
      ef=(b2&0x0F);
      efpar=b3;
      switch (ef) /*convert .mod-commands to the internal format*/
      {
       case 0x0F:
        if (efpar>0x1F) ef=0x10;break; /*set bpm*/
       case 0x08:
        if (efpar<0x80) efpar*=2; else /*set pan*/
        if (efpar==0xA4) efpar=0x80; /*surround my arse.*/
         else efpar=0xFF; /*if pan value is 0x80, it cant be multiplied*/
        break;            /*by 2, as the result wouldn't fit in 8 bits*/
       case 0x0A:ef=0x06; break; /*combined vslide*/
       case 0x0E: /*extended commands*/
        if ((efpar&0xF0)==0x90) /*retrig note*/
         {ef=0x15; efpar=(efpar>>4)&0x0F;} /*retrig note, vslide 0*/
        break;
       default: break;
      }
      song.pattern[i][a*5+2]=ef;
      song.pattern[i][a*5+3]=efpar;
      song.pattern[i][a*5+4]=_nothing; /*volume is always undefined*/
/*
      if ( (i==10) || (i==9) ) {
       printf("samp: %d, note: %d, effe: %d, epar: %d \n",
        song.pattern[i][a*5],song.pattern[i][a*5+1],song.pattern[i][a*5+2],
        song.pattern[i][a*5+3]);
       getch();
      }
*/
     }
   }
  free(p); /*free the temp pattern buffer*/
  printf("patterns read!\n");
  return 0;
 } /*end of loadpatterns*/

 int readsamples() /* 0 successful */
 {
  int a;
  int i,ok=0;
/*  printf("sampleja yhteens %d tavua.\n",totalsamples);
  printf("filess sampleja  %ld tavua.\n",filelength(fileno(f))-(1084+((int)module.channels)*4*64*((int)song.patterns+1))); */
  printf("reading samples..\n");
  fseek(f,1084+((int)module.channels)*4*64*((int)song.patterns+1)+module.file_offset,SEEK_SET);
#ifdef purkka
Not recommended
  fseek(f, filelength(fileno(f)) - totalsamples);
#endif
  for (i=1;i<=module.instruments;i++) if (samples[i].length>0)
  {
   a=samples[i].length;
   samples[i].pan=128;
   ok+=_output_loadsample_8_bits_raw_from_opened_file_curpos(f,i,
           samples[i].c2spd,samples[i].pan,samples[i].loop_start,
           samples[i].loop_endi,samples[i].length,0x80);
   if (ok!=0)
    {
     strcat(error,"load_mod: unable to load samples.\n");
     return -1;
    }
  }
  printf("samples read!\n");
  return ok;
 }

 int loadsong() /* 0 succesful */
 {
  unsigned char b;
  fseek(f,950+module.file_offset,SEEK_SET);
  fread(&b,1,1,f);
  song.length=b;
  printf("song length: %d\n",song.length);
  fread(&b,1,1,f);
/*  printf("restart position: %d (not used)\n",b); */
  song.patterns=0;
  for (b=1;b<=128;b++)
  {
   fread(&song.order[b],1,1,f);
   if ( (song.order[b]>song.patterns) && (b<=song.length) ) song.patterns=song.order[b];
  }
  printf("patterns: %d\n",song.patterns+1);
  if (ftell(f)!=(1080+module.file_offset)) printf("..er..");
  fread(sig,1,4,f);
  sig[4]=0;
/*  printf("module type: %s\n",sig); */
  if (loadpatterns()!=0)
   {
    strcat(error,"unable to load patterns.\n");
    return -1;
   }
  if (readsamples()!=0)
   {
    strcat(error,"unable to load samples.\n");
    return -1;
   }
  return 0;
 }

 f=fopen(name,"rb");
 if (f==NULL)
  {
   strcat(name,".MOD");
   f=fopen(name,"rb");
  }
 if (f==NULL)
  {
   strcat(error,"file not found.\n");
   return -1;
  }
/* printf("loading module: %s\n",name); */
 if (check_mk(f,1)!=0)
  {
   fclose(f);
   strcat(error,"not a 32-instrument MOD module.\n");
   return -1;
  } /*not a valid mod*/

 for (ii=1;ii<=module.channels;ii++)
  switch ((ii-1)&3) /*default pnnings*/
   { /* we're not using the usual lrrl-pannings, but slighty more centered ones */
    case 0:channa[ii].pan=0x39; break;
    case 1:channa[ii].pan=0xC7; break;
    case 2:channa[ii].pan=0xC7; break;
    case 3:channa[ii].pan=0x39; break;
   }
 module.maxsamples=32;
 module.fast_vslides=0;
 module.type=MOD;
 song.speed=6;
 song.bpm=125;
 mastervolume(64);
 getname();
 printf("loading %d-channel MOD module called '%s'\n",module.channels,module.title);
 totalsamples=0;
 if (getsampleinfo()!=0)
  {
   fclose(f);
   strcat(error,"read error.\n");
   return -1;
  }
 if (loadsong()!=0)
  {
   fclose(f);
   strcat(error,"unable to load module.\n");
   return -1;
  }
/* printf("%ld / %ld \n",ftell(f),filelength(fileno(f))); */
 fclose(f);
/* getch(); */
 return 0;
}
/* end of mod.h */
#endif
